/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.AlliedCountry;
import gov.va.med.esr.common.model.lookup.FederalAgency;

/**
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class ReceivedEligibilityTest
    extends AbstractKeyedEntityDAOTestCase {

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        person.setReceivedPrimaryEligiblity(createReceivedEligibility());
        person.addReceivedSecondaryEligibility(createReceivedEligibility());
        return person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person) obj;
        person.setReceivedPrimaryEligiblity(createReceivedEligibility());
        person.removeReceivedSecondaryEligibility((ReceivedEligibility) person.getReceivedSecondaryEligibilities().iterator().next());
        person.addReceivedSecondaryEligibility(createReceivedEligibility());
    }
    
    public void testAlliedCountryFederalAgency() throws Exception {
    	try {
     		AlliedCountry allied = getLookupService().getAlliedCountryByCode("1");
    		
            assertNotNull(allied);
    	}
    	catch (Exception ex) {
    	    ex.printStackTrace();
    		fail("AlliedCountry Failed", ex);
    	} 
    	
    	try {
    		FederalAgency agency = getLookupService().getFederalAgencyByCode("1");
    		assertNotNull(agency);
    	}
    	catch (Exception ex) {
    	    ex.printStackTrace();
    		fail("FederalAgency Failed", ex);
    	}
    }
    		
}