/*
 * Created on Aug 9, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.persistent.hibernate;

//Java classes
import java.util.Iterator;
import java.util.Set;

//ESR classes
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   MERCHA
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PurpleHeartTest extends DataSetupTestCase {
	private PurpleHeart ph = null;
	
	public PurpleHeartTest(String name) {
        super(name);
        super.setDefaultRollback(false);
}
	public void setUpData() throws Exception {
        ph = new PurpleHeart();
        
        DecorationStatus ds = getLookupService().getDecorationStatusByCode("1");
        ph.setStatus(ds);
        
        VAFacility facility = getLookupService().getVaFacilityByCode("402GB");
        ph.setFacility(facility);
        
        RejectionRemark rr = getLookupService().getRejectionRemarkByCode("1");
        ph.setRejectionRemark(rr);
    }
	
	public void tearDownData() throws Exception {
    	ph = null;
    }
	 
	 public void testAddPH() throws Exception {
    	try {
    		// link purple heart to person
    		Person p = getPerson();
    		p.addDecoration(ph);
	   	
    		// save pow with person
    		personDao.saveObject(p);
    		
    		System.out.println("Purple Heart = " + ph);
    	}
    	catch (Exception ex) {
    	    ex.printStackTrace();
    		fail("Failed to add purple heart", ex);
    	} 
    }
	 
	 public void testUpdatePH() throws Exception {
        
     	try {     	    
     	   	// insert a pow
 	        Person p = getPerson();
 	       Set phs = p.getDecorations();
     	    
     	   if(phs.isEmpty()) {
     	   p.addDecoration(ph);
       		personDao.saveObject(p);
       		phs = ((Person) personDao.getByKey(p.getEntityKey())).getDecorations();
 	    }
     	   
     	    Iterator iter = phs.iterator();
     	   if (iter.hasNext()) 
     	   {
     	   		PurpleHeart pt = (PurpleHeart) iter.next();
     	   		pt.setRejectionRemark(getLookupService().getRejectionRemarkByCode("3"));
     	   		personDao.saveObject(p);     		    
     	   		return;                
            }
  	        fail("Did not update purple heart");
     	}
     	catch(Exception ex) {
     		fail("Failed to get purple heart", ex);
     	}
     }
	 
	 public void testGetPH() throws Exception {
	       
	    	try {
	    	    
	    	   	// insert a pow
		        Person p = getPerson();
		        p.removeAllDecorations();
		        p.addDecoration(ph);
		   	
	    	   	// save pow with person
		     	personDao.saveObject(p);
		   	   	
	    	    // refresh data from database 
	    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
	    	    Set phs = retrievedPerson.getDecorations();
	    	    Iterator iter = phs.iterator();
	    	    System.out.println("got purple heart from retrieved");
	    	    while (iter.hasNext()) {
	    	        PurpleHeart pt = (PurpleHeart)iter.next();
	    		    if(ph.equals(pt)) {
	    		       // logger.info("Got POW = " + pw);
	    		        System.out.println("Got Purple Heart = " + pt);
	    		        return;
	    		    }
	            }
	            fail("Could not find Purple Heart ");
	    	}
	    	catch(Exception ex) {
	    		fail("Failed to get Purple Heart", ex);
	    	}
	    }
}
