/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 26, 2004
 */

package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.PatientProviderAssignment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.persistent.person.HealthCareProviderDAO;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Iterator;
import java.util.Set;


public class PreferredFacilityTest extends AbstractKeyedEntityDAOTestCase {
 
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
    	
    	HealthCareProviderDAO providerDao = (HealthCareProviderDAO) this.applicationContext.getBean( "healthCareProviderDAO" );
    	HealthCareProvider provider = providerDao.findByPractitionerID("532723");
    	
        Person person = buildSimplePerson();
        
        PreferredFacility pf = this.createPreferredFacility();
        person.addPreferredFacility(pf);
        
        PatientProviderAssignment pa = this.createProviderAssignment();
        pa.setProvider(provider);
        person.addProviderAssignment(pa);
        
        return person;
    }
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person p = (Person)obj;
        
        Set pfList = p.getPreferredFacilities();
        Iterator it = pfList.iterator();
        PreferredFacility pf = it.hasNext()? ((PreferredFacility)it.next()) : null;
        if (pf != null) {
        	pf.setFacility(this.getLookupService().getVaFacilityByCode("742"));
        }
  
        // provider assignments
        Set paList = p.getProviderAssignments();
        it = paList.iterator();
        PatientProviderAssignment pa = it.hasNext()? ((PatientProviderAssignment)it.next()) : null;
        if (pa != null) {
        	pa.setFacility(this.getLookupService().getVaFacilityByCode("742"));        
        }
    }

}
