/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.PatientProviderAssignmentLite;
import gov.va.med.esr.common.model.person.PreferredFacilityLite;
import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.HealthCareProviderDAO;
import gov.va.med.esr.common.persistent.person.PreferredFacilityDAO;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Set;


/**
 *
 * Test cases directly related to PreferredFacilityPerson
 **/
public class PreferredFacilityPersonTest extends AbstractKeyedEntityDAOTestCase {
	
	public static final String HARDCODED_PSIM_VPID_VALUE = "0000002000000846V157856000000";

	protected DAOTestMode[] setUpTests() {
		return new DAOTestMode[] { TEST_RETRIEVE, TEST_UPDATE_COMMIT, TEST_QUERY};
    }
		
	private HealthCareProvider provider = null;
	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {

		HealthCareProviderDAO providerDao = (HealthCareProviderDAO) this.applicationContext.getBean( "healthCareProviderDAO" );
    	provider = providerDao.findByPractitionerID("532723");
		
		PreferredFacilityDAO pfDao = (PreferredFacilityDAO) this.applicationContext.getBean( "preferredFacilityDAO" );
	   	PreferredFacilityPerson personLite = pfDao.getPreferredFacilityPersonByVPID(new VPIDEntityKeyImpl(HARDCODED_PSIM_VPID_VALUE));
 
		return personLite;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		PreferredFacilityPerson personLite = (PreferredFacilityPerson) obj;
		
		Set pfList = personLite.getPreferredFacilities();
		if (pfList.isEmpty()) {
			PreferredFacilityLite pf = this.createPreferredFacilityLite();
			personLite.addPreferredFacility(pf);
		}
		
		Set paList = personLite.getProviderAssignments();
		if (paList.isEmpty()) {
			PatientProviderAssignmentLite pa = this.createProviderAssignmentLite();
			pa.setProvider(provider);
			personLite.addProviderAssignment(pa);
		}
	}
	
	protected QueryInfo[] getNamedQueries() {
		String[] paramNames = new String[] { "VPIDValue" };
		Object[] params = new String[] { "noMatch" };
		QueryInfo query1 = new QueryInfo("PF_personQuery_GetByVPID", paramNames, params);
			
		paramNames = new String[] { "VPIDValue" };
		params = new String[] { HARDCODED_PSIM_VPID_VALUE };
		QueryInfo query2 = new QueryInfo("PF_personQuery_GetByVPID", paramNames, params);
	
		return new QueryInfo[] { query1, query2 };
	}	
	
	public void testGetPersonByVPID() throws Exception {
		PreferredFacilityDAO dao = (PreferredFacilityDAO) applicationContext.getBean("preferredFacilityDAO");
		 
		PreferredFacilityPerson personLite = dao.getPreferredFacilityPersonByVPID(new VPIDEntityKeyImpl(HARDCODED_PSIM_VPID_VALUE));
		System.out.println("Person Key = " + personLite.getEntityKey());
	}
	
	public void testGetEnrollmentCount() throws Exception {
		PreferredFacilityDAO dao = (PreferredFacilityDAO) applicationContext.getBean("preferredFacilityDAO");
		int count = dao.getEnrollmentRecordCount(CommonEntityKeyFactory.createPersonIdEntityKey("30"));
		assertEquals(3, count);
		
		count = dao.getEnrollmentRecordCount(CommonEntityKeyFactory.createPersonIdEntityKey("42"));
		assertEquals(18, count);
		
		count = dao.getEnrollmentRecordCount(CommonEntityKeyFactory.createPersonIdEntityKey("10"));
		assertEquals(0, count);
	}
}
