/*
 * Created on Dec 17, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.lookup.*;
import gov.va.med.esr.common.model.report.*;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.util.DataSetupTestCase;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.List;

/**
 * @author Yi He
 */
public class PhoneTest extends DataSetupTestCase {
    private Phone phone = null;
    
    public PhoneTest(String name) {
        super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {
        phone = new Phone();
		phone.setPhoneNumber("2143930029");
		PhoneType type = getLookupService().getPhoneTypeByCode("01");
	   	phone.setType(type);
	   	VAFacility vaFacility = getLookupService().getVaFacilityByCode("552");
        phone.setSiteOfChange(vaFacility);
    }
    
     
    public void tearDownData() throws Exception {
    	phone = null;
    }    
    
    public void testEnrollmentHistory() throws Exception {
        try {
	        EligibilityEnrollmentService enrollmentService = (EligibilityEnrollmentService) this.applicationContext.getBean("eligibilityEnrollmentService");
	        Set dates = enrollmentService.getEnrollmentHistoryChangeTimes(new PersonIdEntityKeyImpl(new BigDecimal(189935)));
	        Iterator iter = dates.iterator();
	        while(iter.hasNext()) {
	        	HistoricalInfo hi = (HistoricalInfo) enrollmentService.getEnrollmentHistoryByChangeTime((ChangeEvent)iter.next());
	        	Person historyPerson = (Person) hi.getEntity();
	        	EnrollmentDetermination enrollment = historyPerson.getEnrollmentDetermination();
	        	if(enrollment.getEnrollmentStatus() != null && EnrollmentStatus.CODE_VERIFIED.getName().equals(enrollment.getEnrollmentStatus().getCode())) {
	        		System.out.println("got verified enrollment");
	        	}
	        }
	        
	        System.out.println("No verified enrollment");
        }
        catch (ServiceException serviceEx) {
        	throw new RuleException("Error retrieving and calling EE history service", serviceEx);
        }    	
    }
    
    public void testAddEnrollment() throws Exception {
     	try {     	    
 	        Person p = getPerson();

 	        EGTService egtService = (EGTService) this.applicationContext.getBean( "egtService" );
            EGTSetting egt = egtService.getCurrentEGTSetting();
           
            EnrollmentDetermination enroll = new EnrollmentDetermination();
            enroll.setEgtSetting(egt);
            
             EnrollmentStatus status = getLookupService().getEnrollmentStatusByCode("2");
            
            enroll.setEnrollmentStatus(status);
            
            p.setEnrollmentDetermination(enroll);
           
      		personDao.saveObject(p);

     	}
     	catch(Exception ex) {
     		fail("Failed to get phone", ex);
     	}        
    }

    public void testNoChangePersonUpdate() {
     	try {     	    
    	    Person p = (Person) personDao.getByKey(new PersonIdEntityKeyImpl(new BigDecimal(68)));
   		    personDao.saveObject(p);     		    
     	}
     	catch(Exception ex) {
     		fail("Failed no change person update", ex);
     	}
    }
    
    public void testUpdatePhone() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();
     	    Set phones = p.getPhones();
     	    if(phones.isEmpty()) {
        		p.addPhone(phone);        		
           		personDao.saveObject(p);
           		phones = ((Person) personDao.getByKey(p.getEntityKey())).getPhones();
     	    }
     	    
     	    Iterator iter = phones.iterator();
     	    if (iter.hasNext()) {
                Phone ph = (Phone) iter.next();
                ph.setPhoneNumber(String.valueOf(new Date().getTime()));
        		personDao.saveObject(p);     		    
     		    return;                
            }
  	        fail("Did not update phone");
     	}
     	catch(Exception ex) {
     		fail("Failed to get phone", ex);
     	}
     }
    

    public void uidTest() throws Exception {   
    	System.out.println("ReportParameterSet = " + java.io.ObjectStreamClass.lookup(ReportParameterSet.class).getSerialVersionUID());
    	System.out.println("ReportEnrollmentCategory = " + java.io.ObjectStreamClass.lookup(ReportEnrollmentCategory.class).getSerialVersionUID());
    	
    	System.out.println("StandardReport = " + java.io.ObjectStreamClass.lookup(StandardReport.class).getSerialVersionUID());
    	System.out.println("StandardReport code = " + java.io.ObjectStreamClass.lookup(StandardReport.Code.class).getSerialVersionUID());

    	System.out.println("Quarter = " + java.io.ObjectStreamClass.lookup(Quarter.class).getSerialVersionUID());
    	System.out.println("Quarter code = " + java.io.ObjectStreamClass.lookup(Quarter.Code.class).getSerialVersionUID());
    	
    	System.out.println("ReportScheduleType = " + java.io.ObjectStreamClass.lookup(ReportScheduleType.class).getSerialVersionUID());
    	System.out.println("ReportScheduleType code = " + java.io.ObjectStreamClass.lookup(ReportScheduleType.Code.class).getSerialVersionUID());
    	
    	System.out.println("month" + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.Month.class).getSerialVersionUID());
    	System.out.println("month code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.Month.Code.class).getSerialVersionUID());
    	
    	System.out.println("DayOfQuarter = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.DayOfQuarter.class).getSerialVersionUID());
    	System.out.println("DayOfQuarter code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.DayOfQuarter.Code.class).getSerialVersionUID());

    	System.out.println("WeekOfMonth = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.WeekOfMonth.class).getSerialVersionUID());
    	System.out.println("WeekOfMonth code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.WeekOfMonth.Code.class).getSerialVersionUID());

    	System.out.println("DayOfMonth = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.DayOfMonth.class).getSerialVersionUID());
    	System.out.println("DayOfMonth code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.DayOfMonth.Code.class).getSerialVersionUID());

    	System.out.println("DayOfWeek = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.DayOfWeek.class).getSerialVersionUID());
    	System.out.println("DayOfWeek code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.DayOfWeek.Code.class).getSerialVersionUID());

    	System.out.println("ReportRunFrequency = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportRunFrequency.class).getSerialVersionUID());
    	System.out.println("ReportRunFrequency code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportRunFrequency.Code.class).getSerialVersionUID());


    	System.out.println("ReportFacilityDisplayBy = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy.class).getSerialVersionUID());
    	System.out.println("ReportFacilityDisplayBy code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy.Code.class).getSerialVersionUID());
    	
    	System.out.println("ReportLetterFile = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportLetterFile.class).getSerialVersionUID());
    	System.out.println("ReportLetterFile code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportLetterFile.Code.class).getSerialVersionUID());

    	System.out.println("ReportEEDWeeklyType = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType.class).getSerialVersionUID());
    	System.out.println("ReportEEDWeeklyType code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType.Code.class).getSerialVersionUID());

    	System.out.println("ReportPeriodType = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportPeriodType.class).getSerialVersionUID());
    	System.out.println("ReportPeriodType code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportPeriodType.Code.class).getSerialVersionUID());

    	System.out.println("ReportDetailBy = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportDetailBy.class).getSerialVersionUID());
    	System.out.println("ReportDetailBy code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportDetailBy.Code.class).getSerialVersionUID());

    	System.out.println("ReportDetailFor = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportDetailFor.class).getSerialVersionUID());
    	System.out.println("ReportDetailFor code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportDetailFor.Code.class).getSerialVersionUID());
    	
    	System.out.println("ReportFormat = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportFormat.class).getSerialVersionUID());
    	System.out.println("ReportFormat code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportFormat.Code.class).getSerialVersionUID());
    	
    	System.out.println("ReportExceptionType = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportExceptionType.class).getSerialVersionUID());
    	System.out.println("ReportExceptionType code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportExceptionType.Code.class).getSerialVersionUID());

    	System.out.println("ReportExportedType = " + java.io.ObjectStreamClass.lookup(ReportExportedType.class).getSerialVersionUID());
    	System.out.println("ReportExportedType code = " + java.io.ObjectStreamClass.lookup(ReportExportedType.Code.class).getSerialVersionUID());
    	
    	System.out.println("ReportWorkItemStatus = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportWorkItemStatus.class).getSerialVersionUID());
    	System.out.println("ReportWorkItemStatus code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportWorkItemStatus.Code.class).getSerialVersionUID());

    	System.out.println("ReportDivision = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportDivision.class).getSerialVersionUID());
    	System.out.println("ReportDivision code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportDivision.Code.class).getSerialVersionUID());

    	System.out.println("ReportType = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportType.class).getSerialVersionUID());
    	System.out.println("ReportType code = " + java.io.ObjectStreamClass.lookup(gov.va.med.esr.common.model.lookup.ReportType.Code.class).getSerialVersionUID());

    }
    public void testAddGetPhone() throws Exception {
       
    	try {
    	    
    
    	   	// insert a phone
	        Person p = getPerson();
	        p.removeAllPhones();
	        p.addPhone(phone);
	   	
    	   	// save phone with person
	     	personDao.saveObject(p);
	  	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    Set phones = retrievedPerson.getPhones();
    	    Iterator iter = phones.iterator();
    	    while (iter.hasNext()) {
    	        Phone ph = (Phone)iter.next();
    		    if(phone.getPhoneNumber().equals(ph.getPhoneNumber())) {
    		       // logger.info("Got phone = " + ph);
    		        System.out.println("Got phone = " + ph);
    		        return;
    		    }
            }
            fail("Could not find Phone ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get phone", ex);
    	}
    }

    public void testRemoveAllPhones() throws Exception {
        Person p = getPerson(); // p already has a phone
        p.addPhone(phone);
        
        Phone secondPhone = new Phone();
		secondPhone.setPhoneNumber("9723930029");
		PhoneType type = getLookupService().getPhoneTypeByCode("01");
	   	phone.setType(type);
	   	VAFacility vaFacility = getLookupService().getVaFacilityByCode("552");
        secondPhone.setSiteOfChange(vaFacility);
        p.addPhone(secondPhone);
        
        p.removeAllPhones();
        assertEquals(p.getPhones().size(),0);
    } 
}
