/*
 * Created on Jan 11, 2005
 *
 * Test cases directly related Person
 */
package gov.va.med.esr.common.persistent.hibernate;

import java.math.BigDecimal;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.persistent.person.PersonDAO;


/**
 * @author Yi He
 *
 * Test cases directly related to Person 
 * This includes test for Person, Name, BirthRecord, DeathRecord
 **/
public class PersonTest extends AbstractKeyedEntityDAOTestCase {
	
	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		return buildPerson();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) {
		Person p = (Person) obj;
		p.setSensitiveRecord(Boolean.TRUE);
		p.setVeteran(Boolean.TRUE);		
	}
	
	protected QueryInfo[] getNamedQueries() {
		String[] paramNames = new String[] { "VPIDValue" };
		Object[] params = new String[] { "noMatch" };
		QueryInfo query1 = new QueryInfo("personQuery_GetByVPID", paramNames, params);
		
  		paramNames = new String[] { "personId" };
		params = new Object[] { new BigDecimal("67091") };
		QueryInfo query2 = new QueryInfo("personQuery_GetVPIDByPersonId", paramNames, params);
		
		paramNames = new String[] { "VPIDValue" };
		params = new String[] { "1127146862120aaa-271468146862" };
		QueryInfo query3 = new QueryInfo("personQuery_GetPersonIdByVPID", paramNames, params);
	
		return new QueryInfo[] { query1, query2, query3 };
	}	
	
	public void testGetPersonIdByVPID() throws Exception {
		PersonDAO dao = (PersonDAO) applicationContext.getBean("personDAO");
		 
		PersonIdEntityKey personId = dao.getPersonIdByVPID(new VPIDEntityKeyImpl("1127146862120aaa-271468146862"));
		System.out.println("Person Id = " + personId);
	}

	public void testGetPersonByVPID() throws Exception {
		PersonDAO dao = (PersonDAO) applicationContext.getBean("personDAO");
		 
		Person person = dao.getByVPID(new VPIDEntityKeyImpl("1127146862120aaa-271468146862"));
		System.out.println("Person Key = " + person.getPersonEntityKey());
	}
}
