/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;

import gov.va.med.ps.model.PersonVPID;

/**
 * Initial javadoc for class PersonChangeLogEntryTest.
 * TODO - Add content here
 * 
 * Created Apr 3, 2006 1:01:43 PM
 * @author DNS   BOHMEG
 */
public class PersonChangeLogEntryTest extends AbstractKeyedEntityDAOTestCase {

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		PersonChangeLogEntry log = new PersonChangeLogEntry();
		log.setIncomeYear(new Integer(2006));
		log.setSubmittedDate(new Date());
		log.setSubmitterDescription("UI");
		log.setPersonEntityKey(CommonEntityKeyFactory.createPersonIdEntityKey(PersonVPID.HARDCODED_PERSONID_ID1));
		return log;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		PersonChangeLogEntry log = (PersonChangeLogEntry) obj;
		log.setSubmitterDescription("UI (updated)");
	}
}
