/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;
import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class PatientVisitSummaryTest extends AbstractKeyedEntityDAOTestCase {

    private VAFacility facility1;
    private VAFacility facility2;
    private VAFacility facility3;
    private Integer incomeYear = new Integer(1999);

    protected void customSetUp() throws Exception {
        facility1 = getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName());
        facility2 = getLookupService().getVaFacilityByCode(VAFacility.CODE_CONNECTICUT_HCS.getName());
        facility3 = getLookupService().getVaFacilityByCode(VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER.getName());
        super.customSetUp();
    }
    
    /**
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        person.setPatientVisitSummary(incomeYear, facility1, createPatientVisitSummary(incomeYear));
        person.setPatientVisitSummary(incomeYear, facility2, createPatientVisitSummary(incomeYear));
        person.setPatientVisitSummary(incomeYear, facility3, createPatientVisitSummary(incomeYear));
        person.setPatientVisitSummary(incomeYear, facility3, createPatientVisitSummary(incomeYear));
        return person;
    }

    /**
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person)obj;
        assertNotNull("Set of PatientVisitSummary should never be null.", person.getPatientVisitSummaries());
        assertEquals("All the PatientVisitSummary Objects not saved.", person.getPatientVisitSummaries().size(), 3);
        assertNotNull("Retrieved PatientVisitSummary(1) is null.", person.getPatientVisitSummary(incomeYear, facility1));
        assertNotNull("Retrieved PatientVisitSummary(2) is null.", person.getPatientVisitSummary(incomeYear, facility2));
        assertNotNull("Retrieved PatientVisitSummary(3) is null.", person.getPatientVisitSummary(incomeYear, facility3));
        PatientVisitSummary visitSummary = person.getPatientVisitSummary(incomeYear, facility1);
        visitSummary.setOutpatientDays(new Integer(1));
        person.setPatientVisitSummary(incomeYear, facility2, null);
        person.setPatientVisitSummary(incomeYear, facility3, createPatientVisitSummary());
    }
}