/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 10, 2005
 */

package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.lookup.NTRVerificationMethod;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 * @author Yi He
 */
public class NoseThroatRadiumTest extends DataSetupTestCase {

    public NoseThroatRadiumTest(String name) {
        super(name);
        super.setDefaultRollback(false);        
    }	

    /**
     * Insert a new persist object
     * 
     * @see junit.framework.TestCase#setUp()
     * @throws Exception
     */
    public void setUpData() throws Exception {
        Person person = getPerson();
        this.noseThroatRadium = new NoseThroatRadium();
        this.noseThroatRadium.setDiagnosedWithCancer(Boolean.TRUE);
        this.noseThroatRadium.setFromAviatorServiceBefore1955(Boolean.FALSE);
        this.noseThroatRadium.setFromSubmarinerServiceBefore1965(Boolean.TRUE);
        this.noseThroatRadium.setReceivingTreatment(TriState.UNKNOWN);
        this.noseThroatRadium.setVerificationDate(new Date());
        NTRVerificationMethod method = getLookupService().getNTRVerificationMethodByCode("S");
		this.noseThroatRadium.setVerificationMethod(method);
    }


    public void tearDownData() throws Exception {
        noseThroatRadium = null;
    }    
    

    public void testUpdateNoseThroatRadium() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

    	    ClinicalDetermination ntr = (ClinicalDetermination) p.getClinicalDeterminationByType(NoseThroatRadium.class);
    	    if(ntr == null) {
        		p.addClinicalDetermination(this.noseThroatRadium);
           		personDao.saveObject(p);
     	    }

    	    NoseThroatRadium ntrRetrieved = (NoseThroatRadium)((Person) personDao.getByKey(p.getEntityKey())).getClinicalDeterminationByType(NoseThroatRadium.class);
    	    ntrRetrieved.setVerificationDate(new Date());
            personDao.saveObject(p);
            
            NoseThroatRadium ntrFinal = (NoseThroatRadium)((Person) personDao.getByKey(p.getEntityKey())).getClinicalDeterminationByType(NoseThroatRadium.class);
            if(ntrFinal.equals(ntrRetrieved))
     		    return;                          
  	        fail("Did not update ntr");
     	}
     	catch(Exception ex) {
     		fail("Failed to get ntr", ex);
     	}
     }
    
    public void testGetAddNoseThroatRadium() throws Exception {
       
    	try {
    	    
	        Person p = getPerson();
	        p.removeAllClinicalDeterminations();
	        p.addClinicalDetermination(noseThroatRadium);
	   	
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    ClinicalDetermination retrievedNTR = (ClinicalDetermination) retrievedPerson.getClinicalDeterminationByType(NoseThroatRadium.class);
    		if(noseThroatRadium.equals(retrievedNTR)) {
    		    logger.info("Got ntr  = " + noseThroatRadium);
    		    return;    		
            }
            fail("Could not find ntr ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get ntr", ex);
    	}
    }

    private NoseThroatRadium noseThroatRadium;
}