/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 28, 2004
 */

package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

import java.util.Iterator;
import java.util.Set;

/**
 * @author DNS   SUNS
 * 
 */
public class MonetaryBenefitTest extends DataSetupTestCase {
	private MonetaryBenefit benefit = null;
	private MonetaryBenefitAward award = null;
		
	public MonetaryBenefitTest(String name) {
		super(name);
		super.setDefaultRollback(false);
		
	}
    
	public void setUpData() throws Exception {
		award  = new MonetaryBenefitAward();
		benefit  = new MonetaryBenefit();
		
        MonetaryBenefitType type = getLookupService().getMonetaryBenefitTypeByCode("HB");
        benefit.setType(type);
    }
    
	public void tearDownData() throws Exception {
		award = null;
		benefit = null;
    }
	
	public void testAddMonetaryBenefit() throws Exception {
    	try {
    		// link MonetaryBenefitAward to person
    		Person p = getPerson();
    		p.setMonetaryBenefitAward(award);
    		
    		award.addMonetaryBenefit(benefit);
    		
    		// save MonetaryBenefitAward with person
    		personDao.saveObject(p);
    	}
    	catch (Exception ex) {
    	    ex.printStackTrace();
    		fail("Failed to add MonetaryBenefit", ex);
    	} 
    }
	 
	 public void testUpdateMonetaryBenefit() throws Exception {
        
     	try {
     		
     		//insert a MonetaryBenefitAward
     		Person p = getPerson();
     		MonetaryBenefitAward mba = p.getMonetaryBenefitAward();
     		Set benefits = mba.getMonetaryBenefits();
 	       
 	      
 	      if(mba.equals(null)) {
 	      	p.setMonetaryBenefitAward(mba);
 	    
       		personDao.saveObject(p);
       		mba = ((Person) personDao.getByKey(p.getEntityKey())).getMonetaryBenefitAward();
 	    }
 	      
 	     if(benefits.isEmpty()) {
 	     	mba.addMonetaryBenefit(benefit);
       		personDao.saveObject(p);
       		benefits = ((MonetaryBenefitAward) personDao.getByKey(p.getEntityKey())).getMonetaryBenefits();
 	    }
 	    Iterator iter = benefits.iterator();
 	    
  	   if (iter.hasNext()) {
  	   		MonetaryBenefit bf = (MonetaryBenefit) iter.next();
  	   		bf.setType(getLookupService().getMonetaryBenefitTypeByCode("PN"));
		    personDao.saveObject(p);     		    
	   		return;
  	   }
     	}
     	catch(Exception ex) {
     		fail("Failed to get MonetaryBenefitAward", ex);
     	}
     }
	 
	 public void testGetMonetaryBenefit() throws Exception {
	       
	    	try {
	    	    
	    		//insert a MonetaryBenefitAward
		        Person p = getPerson();
		        p.setMonetaryBenefitAward(null);
		        p.setMonetaryBenefitAward(award);
		        
		        //insert a MonetaryBenefit
		        award.removeMonetaryBenefit(benefit);
		        award.addMonetaryBenefit(benefit);
		   	
	    	   	// save pow with person
		     	personDao.saveObject(p);
		   	   	
	    	    // refresh data from database 
	    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
	    	    MonetaryBenefitAward myAward= retrievedPerson.getMonetaryBenefitAward();
	    	    Set myBenefits= myAward.getMonetaryBenefits();
	    	     
	    	    System.out.println("got MonetaryBenefitAward from retrieved");
	    		    if(myAward.equals(myAward)) {
	    		       // logger.info("Got MonetaryBenefitAward = " + myAward);
	    		        System.out.println("Got MonetaryBenefitAward = " + myAward);
	    		    }
	    		    
	    		    System.out.println("got MonetaryBenefit from retrieved");
	    		    if(myBenefits.equals(myBenefits)) {
	    		       // logger.info("Got MonetaryBenefit = " + myBenefits);
	    		        System.out.println("Got MonetaryBenefit = " + myBenefits);
	    		    }
	    	}
	    	catch(Exception ex) {
	    		fail("Failed to get MonetaryBenefitAward", ex);
	    	}
	    }
}