/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 10, 2005
 */

package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 */
public class MilitarySexualTraumaTest extends DataSetupTestCase {

    public MilitarySexualTraumaTest(String name) {
        super(name);
        super.setDefaultRollback(false);        
    }

    /**
     * Insert a new persist object
     * 
     * @see junit.framework.TestCase#setUp()
     * @throws Exception
     */
    public void setUpData() throws Exception {
        Person person = getPerson();
        this.militarySexualTrauma = new MilitarySexualTrauma();
        MilitarySexualTraumaStatus status = getLookupService().getMilitarySexualTraumaStatusByCode("Y");
	   	militarySexualTrauma.setStatus(status);
    }

    public void tearDownData() throws Exception {
        militarySexualTrauma = null;
    }    
    

    public void testUpdateMilitarySexualTrauma() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

    	    ClinicalDetermination mst = (ClinicalDetermination) p.getClinicalDeterminationByType(MilitarySexualTrauma.class);
    	    if(mst == null) {
        		p.addClinicalDetermination(this.militarySexualTrauma);
           		personDao.saveObject(p);
     	    }

    	    MilitarySexualTrauma mstRetrieved = (MilitarySexualTrauma)((Person) personDao.getByKey(p.getEntityKey())).getClinicalDeterminationByType(MilitarySexualTrauma.class);
    	    mstRetrieved.setStatusChangeDate(new Date());
            personDao.saveObject(p);
            
            MilitarySexualTrauma mstFinal = (MilitarySexualTrauma)((Person) personDao.getByKey(p.getEntityKey())).getClinicalDeterminationByType(MilitarySexualTrauma.class);
            if(mstFinal.equals(mstRetrieved))
     		    return;                          
  	        fail("Did not update mst");
     	}
     	catch(Exception ex) {
     		fail("Failed to get mst", ex);
     	}
     }
    
    public void testGetMilitarySexualTrauma() throws Exception {
       
    	try {
    	    
	        Person p = getPerson();
	        p.removeAllClinicalDeterminations();
	        p.addClinicalDetermination(militarySexualTrauma);
	   	
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    ClinicalDetermination retrievedMST = (ClinicalDetermination) retrievedPerson.getClinicalDeterminationByType(MilitarySexualTrauma.class);
    		if(militarySexualTrauma.equals(retrievedMST)) {
    		    System.out.println("Got mst  = " + militarySexualTrauma);
    		    return;    		
            }
            fail("Could not find mst ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get mst", ex);
    	}
    }

    private MilitarySexualTrauma militarySexualTrauma;

}