/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

// Java classes
import java.util.Date;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * This class is a JUnit that tests Military Service and its sub-attributes.
 * Note that Special Factors are tested in the SpecialFactorTest class and are not tested in this class.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class MilitaryServiceTest extends AbstractKeyedEntityDAOTestCase
{
    /**
     * (non-Javadoc)
     *
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception
    {
        // Build a person
        Person person = buildSimplePerson();
        person.setClaimFolderNumber("JDCFN");

        return person;
    }

    /**
     * (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj)
    {
        // change the modify scenario to just add new MSSR and MSE/CE
        try
        {
            Person person = (Person)obj;
            
            /* uncommenting this results in a Hibernate exception since we are dereferencing phantom MilitaryService
             * and have the mapping cascades set to all-delete-orphan for MSE in MS component
            // Add military service information
            MilitaryService militaryService = new MilitaryService();
            militaryService.setDischargeDueToDisability(Boolean.TRUE);
            militaryService.setDisabilityRetirementStatus(getLookupService().getDisabilityRetirementStatusByCode(
                DisabilityRetirementStatus.CODE_YES_RECEIVING_RETIREMENT.getName()));
            militaryService.setCombatVeteranEligibilityEndDate(new Date());
            person.setMilitaryService(militaryService);*/

            // Add military service site record information
            MilitaryServiceSiteRecord siteRecord = new MilitaryServiceSiteRecord();
            siteRecord.setSite(getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
            siteRecord.setServicePeriod(getLookupService().getServicePeriodByCode(
                ServicePeriod.CODE_AIR_FORCE.getName()));
            siteRecord.setFilipinoVeteranProof(getLookupService().getFilipinoVeteranProofByCode(
                FilipinoVeteranProof.CODE_US_BIRTH_CERTIFICATE.getName()));
            person.getMilitaryService().addMilitaryServiceSiteRecord(siteRecord);

            // Add military service episode information
            MilitaryServiceEpisode episode = new MilitaryServiceEpisode();
            episode.setServiceNumber("Service Number 1");
            episode.setStartDate(ImpreciseDateUtils.createImpreciseDate(1950, 1));
            episode.setEndDate(new ImpreciseDate(new Date()));
            episode.setServiceBranch(getLookupService().getServiceBranchByCode(
                ServiceBranch.CODE_COAST_GUARD.getName()));
            episode.setDischargeType(getLookupService().getDischargeTypeByCode(
                DischargeType.CODE_HONORABLE.getName()));
            siteRecord.addMilitaryServiceEpisode(episode);

            // Add conflict episode
            ConflictExperience conflict = new ConflictExperience();
            conflict.setConflictLocation(getLookupService().getConflictByCode(
                ConflictLocation.CODE_LEBANON.getName()));
            conflict.setStartDate(ImpreciseDateUtils.createImpreciseDate(2003));
            conflict.setEndDate(new ImpreciseDate(new Date()));
            siteRecord.addConflictExperience(conflict);
            
            
            /*person.setClaimFolderNumber("JDCFN2");
            MilitaryService militaryService = person.getMilitaryService();
            militaryService.setDischargeDueToDisability(Boolean.FALSE);
            militaryService.setDisabilityRetirementStatus(getLookupService().getDisabilityRetirementStatusByCode(
                DisabilityRetirementStatus.CODE_YES_RECEIVING_RETIREMENT_LIEU_COMPENSATION.getName()));
            militaryService.setCombatVeteranEligibilityEndDate(new Date());

            // Modify the original site record
            MilitaryServiceSiteRecord origSiteRecord =
                militaryService.getMilitaryServiceSiteRecordsBySite(VAFacility.CODE_HEC.getName());
            if (origSiteRecord == null)
            {
                throw new RuntimeException("Original HEC Facility not found.");
            }
            origSiteRecord.setServicePeriod(getLookupService().getServicePeriodByCode(
                ServicePeriod.CODE_CHAMPUS.getName()));

            // Add another military service site record
            MilitaryServiceSiteRecord siteRecord = new MilitaryServiceSiteRecord();
            siteRecord.setSite(getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
            siteRecord.setServicePeriod(getLookupService().getServicePeriodByCode(
                ServicePeriod.CODE_ARMY.getName()));
            siteRecord.setFilipinoVeteranProof(getLookupService().getFilipinoVeteranProofByCode(
                FilipinoVeteranProof.CODE_VA_COMPENSATION_AT_FULL_DOLLAR_RATE.getName()));
            militaryService.addMilitaryServiceSiteRecord(siteRecord);

            // Modify military service episode information
            Set episodes = origSiteRecord.getMilitaryServiceEpisodes();
            for (Iterator iterator = episodes.iterator(); iterator.hasNext();)
            {
                MilitaryServiceEpisode episode = (MilitaryServiceEpisode)iterator.next();
                episode.setServiceNumber("Service Number 2");
                episode.setStartDate(ImpreciseDateUtils.createImpreciseDate(1955, 1));
                episode.setEndDate(new ImpreciseDate(new Date()));
                episode.setServiceBranch(getLookupService().getServiceBranchByCode(
                    ServiceBranch.CODE_MARINE_CORPS.getName()));
                episode.setDischargeType(getLookupService().getDischargeTypeByCode(
                    DischargeType.CODE_DISHONORABLE.getName()));
            }

            // Modify conflict experience information
            Set experiences = origSiteRecord.getConflictExperiences();
            for (Iterator iterator = experiences.iterator(); iterator.hasNext();)
            {
                ConflictExperience conflict = (ConflictExperience)iterator.next();
                conflict.setConflictLocation(getLookupService().getConflictByCode(
                    ConflictLocation.CODE_PANAMA.getName()));
                conflict.setStartDate(new Date());
                conflict.setEndDate(new Date());
            }*/
        }
        catch (Exception ex)
        {
            throw new RuntimeException("Error in modifyTestObject.", ex);
        }
    }
}