/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase.QueryInfo;
import gov.va.med.esr.common.persistent.messaging.MessageLogEntryDAO;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.persistent.DAOException;

import java.util.Date;
import java.util.List;

/**
 * Initial javadoc for class MessageLogEntryTest.
 * TODO - Add content here
 * 
 * Created Aug 10, 2005 12:37:57 PM
 * @author DNS   BOHMEG
 */
public class MessageLogEntryTest extends AbstractKeyedEntityDAOTestCase {

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		MessageLogEntry log = new MessageLogEntry();
		log.setControlIdentifier("TestControlId");
		log.setType(getLookupService().getMessageTypeByCode(MessageType.CODE_ORUZ07_TO_ESR.getName()));
		log.setRetransmissionCount(1);
		log.setAckDate(new Date());
		log.setErrorText("errorText....");
		log.setFormattedBody("formattedBody....");
		log.setInternalErrorText("internalErrorText....");
		log.setTransmissionDate(new Date());
		log.setVaFacility(getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
		log.setBody("body...");
		log.setAckType(getLookupService().getAckTypeByCode(AckType.CODE_AA));
		log.setStatus(getLookupService().getMessageStatusByCode(MessageStatus.COMPLETE));
		log.setSiteReceivedEligibilityStatus( "V" );
		return log;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		MessageLogEntry log = (MessageLogEntry) obj;
		log.setRetransmissionCount(3);
		log.setSiteReceivedEligibilityStatus( "P" );
	}
	
	protected QueryInfo[] getNamedQueries()
    {
        String[] paramNames = new String[] {
                MessageLogEntryDAO.PARAM_MESSAGE_STATUS,
                MessageLogEntryDAO.PARAM_RETRANSMISSION_WAIT_PERIOD,
                MessageLogEntryDAO.PARAM_RETRANSMISSION_COUNT,
                MessageLogEntryDAO.PARAM_MESSAGE_TYPE};
        
        Object[] values = new Object[] { MessageStatus.AWAITING_ACKNOWLEDGEMENT.getCode(), new Integer(2),
                new Integer(3) , MessageType.CODE_MFNZEG_TO_SITE.getCode()};
        
        return new QueryInfo[] { new QueryInfo(
                MessageLogEntryDAO.FIND_BY_RETRANSMISSION_WAIT_PERIOD_AND_COUNT_FOR_EGT,
                paramNames, values) };
    }
	
	

}
