/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.batchprocess.model.JobStatus;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Initial javadoc for class JobConfigTest.
 * TODO - Add content here
 * 
 * Created Sep 29, 2006 10:12:24 AM
 * @author DNS   BOHMEG
 */
public class JobResultTest extends AbstractKeyedEntityDAOTestCase {
	private static final String JOB_NAME = "testJobName";
	private static final String JOB_GROUP = "testJobGroup";
	
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		JobResult jr = new JobResult();
		jr.setJobName(JOB_NAME);
		jr.setJobGroup(JOB_GROUP);
		jr.setStartDate(new Date());
		jr.setStatistics("a=b,c=d");
		jr.setContext("bea");
		jr.setStatus(JobStatus.IN_PROCESS);
		return jr;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		JobResult jr = (JobResult) obj;
		jr.setStatus(JobStatus.COMPLETE);
		jr.setEndDate(new Date());
	}
	
	protected QueryInfo[] getNamedQueries() {
		QueryInfo[] queries = new QueryInfo[4];
		queries[0] = new QueryInfo("jobResultQuery_GetByJobName", new String[] {"jobName"}, new String[] {JOB_NAME});
		queries[1] = new QueryInfo("jobResultQuery_GetByStatus", new String[] {"status"}, new String[] {JobStatus.COMPLETE.getCode()});
		queries[2] = new QueryInfo("jobResultQuery_GetFinishedByJobNameAndStatus", new String[] {"jobName"}, new String[] {JOB_NAME});
		queries[3] = new QueryInfo("jobResultQuery_GetFinishedByJobNameAndJobGroupAndStatus", new String[] {"jobName", "jobGroup"},
				new String[] {JOB_NAME, JOB_GROUP});
		
		return queries;
	}	
}
