/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase.QueryInfo;
import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Initial javadoc for class JobConfigTest.
 * TODO - Add content here
 * 
 * Created Sep 29, 2006 10:12:24 AM
 * @author DNS   BOHMEG
 */
public class JobConfigTest extends AbstractKeyedEntityDAOTestCase {
	private static final String JOB_NAME = "testJobName";
	private static final String JOB_GROUP = "testJobGroup";
	
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		JobConfig jc = new JobConfig();
		jc.setJobName(JOB_NAME);
		jc.setJobGroup(JOB_GROUP);
		jc.setEmailDistributionList("PII                                         .com");
		return jc;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		JobConfig jc = (JobConfig) obj;
		jc.setEmailDistributionList(jc.getEmailDistributionList() + ",flim@dotcom.com");
	}
	
	protected QueryInfo[] getNamedQueries() {
		QueryInfo[] queries = new QueryInfo[2];
		queries[0] = new QueryInfo("jobConfigQuery_GetByJobName", new String[] {"jobName"}, new Object[] {JOB_NAME});
		queries[1] = new QueryInfo("jobConfigQuery_GetByJobNameAndJobGroup", new String[] {"jobName", "jobGroup"},
				new Object[] {JOB_NAME, JOB_GROUP});		
		return queries;
	}	
}
