/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

// Java classes
import java.util.Iterator;
import java.util.Set;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.person.Person;

/**
 * InsurancePolicy JUnit Test case
 * @author DNS   MANSOG
 * @date Jul 29, 2005 3:27:45 PM
 * @version 1.0
 */
public class InsurancePolicyTest
    extends AbstractKeyedEntityDAOTestCase {

    protected DAOTestMode[] setUpTests() {
		return new DAOTestMode[] { TEST_UPDATE_COMMIT};
    }
    
    public void testBadPhoneType() throws Exception {
        PrivateInsurance pi = createPrivateInsurance();
        try {
            pi.setBusinessPhone(createPhone(getLookupService().getPhoneTypeByCode(PhoneType.CODE_MOBILE.getName())));
            fail("Was expecting IllegalArgumentException because Business phone type is incorrect.");
        } catch (IllegalArgumentException ex) {
            //Was expecting this exception because of wrong business phone type.
        }        
    }
    
    public void testBadFaxType() throws Exception {
        PrivateInsurance pi = createPrivateInsurance();
        try {
            pi.setFax(createPhone(getLookupService().getPhoneTypeByCode(PhoneType.CODE_BUSINESS.getName())));
            fail("Was expecting IllegalArgumentException because Phone type (FAX) is incorrect.");
        } catch (IllegalArgumentException ex) {
            //Was expecting this exception because of wrong phone type (fax).
        }        
    }
    
    /**
     * (non-Javadoc)
     *
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        person.addInsurance(buidPrivateInsurance());
        person.addInsurance(buildMedicare());
        person.addInsurance(buildMedicare());
        return person;
    }

    private Medicare buildMedicare() throws Exception {
        Medicare medicare = createMedicareInsurance();
        medicare.setInsurancePlan(createInsurancePlan());
        medicare.setAddress(createAddress(getLookupService().getAddressTypeByCode(AddressType.CODE_BUSINESS_ADDRESS.getName())));
        return medicare;
    }

    private PrivateInsurance buidPrivateInsurance() throws Exception {
        PrivateInsurance pi = createPrivateInsurance();
        pi.setInsurancePlan(createInsurancePlan());
        pi.setAddress(createAddress(getLookupService().getAddressTypeByCode(AddressType.CODE_BUSINESS_ADDRESS.getName())));
        pi.setBusinessPhone(createPhone(getLookupService().getPhoneTypeByCode(PhoneType.CODE_BUSINESS.getName())));
        pi.setFax(createPhone(getLookupService().getPhoneTypeByCode(PhoneType.CODE_FAX.getName())));
        return pi;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person) obj;
        Set insurances = person.getInsurances();
        Medicare toDelete = null;
        for (Iterator iter = insurances.iterator(); iter.hasNext();) {
            InsurancePolicy insurancePolicy = (InsurancePolicy) iter.next();
            if (insurancePolicy instanceof PrivateInsurance) {
                modifyPrivateInsuranceData((PrivateInsurance) insurancePolicy);
            } else if (insurancePolicy instanceof Medicare) {
                Medicare medicare = (Medicare) insurancePolicy;
                medicare.setInsurancePlan(null);
                toDelete = medicare;
            }
        }
        if (toDelete != null) {
            person.removeInsurance(toDelete);
        }
        person.addInsurance(buidPrivateInsurance());
        
    }

    private void modifyPrivateInsuranceData(PrivateInsurance pi) throws Exception {
        InsuranceSubscriber subscriber = new InsuranceSubscriber();
        subscriber.setName(createName().getGivenName());
        subscriber.setRelationship(getRandomInsuredRelationship());
        pi.setSubscriber(subscriber);
        pi.setAddress(createAddress());
        pi.setBusinessPhone(createPhone(getLookupService().getPhoneTypeByCode(PhoneType.CODE_BUSINESS.getName())));
        pi.setFax(null); //remove fax
        pi.setInsurancePlan(createInsurancePlan());
    }
}