/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 26, 2004
 */

package gov.va.med.esr.common.persistent.hibernate;

//import java.math.BigDecimal;
//import java.util.Date;

//import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import java.util.Date;

import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;


/**
 * @author DNS   SUNS
 * @author Yi He
 */

public class IneligibilityFactorTest extends DataSetupTestCase {
    public IneligibilityFactorTest(String name) {
        super(name);
        super.setDefaultRollback(false);        
    }

    /**
     * Insert a new persist object
     * 
     * @see junit.framework.TestCase#setUp()
     * @throws Exception
     */
    public void setUpData() throws Exception {
        Person person = getPerson();
        this.ineligibilityFactor = new IneligibilityFactor();
        ineligibilityFactor.setIneligibleDate(new Date());
        ineligibilityFactor.setReason("No service record");
    }    

    public void testUpdateIneligibilityFactor() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

    	    IneligibilityFactor ineligibilityFactor = (IneligibilityFactor) p.getIneligibilityFactor();
    	    if(ineligibilityFactor == null) {
        		p.setIneligibilityFactor(this.ineligibilityFactor);
           		personDao.saveObject(p);
     	    }

    	    IneligibilityFactor ineligibilityFactorRetrieved = (IneligibilityFactor)((Person) personDao.getByKey(p.getEntityKey())).getIneligibilityFactor();
    	    ineligibilityFactorRetrieved.setIneligibleDate(new Date());
            personDao.saveObject(p);
            
            IneligibilityFactor ineligibilityFactorFinal = (IneligibilityFactor)((Person) personDao.getByKey(p.getEntityKey())).getIneligibilityFactor();
            if(ineligibilityFactorFinal.equals(ineligibilityFactorRetrieved))
     		    return;                          
  	        fail("Did not update ineligibilityFactor");
     	}
     	catch(Exception ex) {
     		fail("Failed to get ineligibilityFactor", ex);
     	}
     }
    
    public void testAddGetIneligibilityFactor() throws Exception {
       
    	try {
    	    
	        Person p = getPerson();
	        p.setIneligibilityFactor(ineligibilityFactor);
	   	
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    IneligibilityFactor retrievedFactor = (IneligibilityFactor) retrievedPerson.getIneligibilityFactor();
    		if(retrievedFactor.getReason().equals(ineligibilityFactor.getReason())) {
    		    System.out.println("Got ineligibilityFactor  = " + ineligibilityFactor);
    		    return;    		
            }
            fail("Could not find ineligibilityFactor ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get ineligibilityFactor", ex);
    	}
    }

    private IneligibilityFactor ineligibilityFactor;
}