/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 14, 2005
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

// Java classes
import java.util.Date;

// Library classes

// Framework classes

// EDB Classes
import gov.va.med.esr.common.util.DataSetupTestCase;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Yi He
 * @version 1.0
 */
public class IncompetenceRulingTest extends DataSetupTestCase {
	private IncompetenceRuling ruling = null;
	
	public IncompetenceRulingTest(String name) {
		super(name);
		super.setDefaultRollback(false);
		
	}
	
	public void setUpData() throws Exception {
        ruling  = new IncompetenceRuling();
 
        ruling.setCivilRulingDate(new ImpreciseDate(new Date()));
        ruling.setVaRulingDate(new ImpreciseDate(new Date()));
        ruling.setIncompetent(Boolean.TRUE);
    }
    
	public void tearDownData() throws Exception {
		ruling = null;
    }
    
    public void testAddIncompetenceRuling() throws Exception {
    	try {
    		// link IncompetenceRuling to person
    		Person p = getPerson();
    		p.setIncompetenceRuling(ruling);
	   	
    		// save IncompetenceRuling with person
    		personDao.saveObject(p);    	   
    	}
    	catch (Exception ex) {
    	    ex.printStackTrace();
    		fail("Failed to add IncompetenceRuling", ex);
    	} 
    }
	 
	 public void testUpdateIncompetenceRuling() throws Exception {
        
     	try {     	    
     	   	// insert a CancelDecline
 	        Person p = getPerson();
 	       IncompetenceRuling ir = p.getIncompetenceRuling();
     	    
     	   if(ir.equals(null)) {
    		p.setIncompetenceRuling(ir);
       		personDao.saveObject(p);
       		ir = ((Person) personDao.getByKey(p.getEntityKey())).getIncompetenceRuling();
 	    }
 	    
     	   		ir.setCivilRulingDate(new ImpreciseDate(new Date()));
     	   		ir.setVaRulingDate(new ImpreciseDate(new Date()));
     	   		personDao.saveObject(p);     		    
     	   		return;                
     	}
     	catch(Exception ex) {
     		fail("Failed to get IncompetenceRuling", ex);
     	}
     }
	 
	 public void testGetIncompetenceRuling() throws Exception {
	       
	    	try {
	    	    
	    	   	// insert a IncompetenceRuling
		        Person p = getPerson();
		        p.setIncompetenceRuling(null);
		        p.setIncompetenceRuling(ruling);
		   	
	    	   	// save pow with person
		     	personDao.saveObject(p);
		   	   	
	    	    // refresh data from database 
	    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
	    	    IncompetenceRuling ir= retrievedPerson.getIncompetenceRuling();
	    	     
	    	    System.out.println("got IncompetenceRuling from retrieved");
	    		    if(ir.equals(ir)) {
	    		       // logger.info("Got POW = " + pw);
	    		        System.out.println("Got IncompetenceRuling = " + ir);
	    		        return;
	    		    }
	    	}
	    	catch(Exception ex) {
	    		fail("Failed to get IncompetenceRuling", ex);
	    	}
	    }
}

