/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 26, 2004
 */

package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author DNS   SUNS
 * @author Yi He
 */
public class IncomeTstTest extends AbstractKeyedEntityDAOTestCase {
    private Integer incomeYear = new Integer(2005);

    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        
        IncomeTest incomeTest = new IncomeTest();
        incomeTest.setIncomeYear(incomeYear);
	   	IncomeTestType type = getRandomIncomeTestType();
        incomeTest.setType(type);
        incomeTest.setAdjudicationDate(new Date());
        incomeTest.setDeductibleExpenses(new BigDecimal(100));
        incomeTest.setNetworthThreshold(new BigDecimal(200));
        incomeTest.setChildIncomeExclusionThreshold(new BigDecimal(300));
        incomeTest.setPensionThreshold(new BigDecimal(400));
       
        incomeTest.setHardship(createHardship("illness"));
        
        MeansTestStatus mtStatus = getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_EXEMPT.getName());

        IncomeTestStatus status = new IncomeTestStatus();
        status.setStatus(mtStatus);
        status.setType(type);
        incomeTest.addStatus(status);
        
        incomeTest.setGmtAddress(createSimpleAddress());
        
        person.setIncomeTest(incomeYear, incomeTest);
        return person;
    }
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person p = (Person)obj;
        IncomeTest test = p.getIncomeTest(incomeYear);
        assertNotNull("IncomeTest is not suppose to be null", test);
        test.setAdjudicationDate(new Date());
        test.setDeductibleExpenses(new BigDecimal(100));
        test.setNetworthThreshold(new BigDecimal(200));
        test.setChildIncomeExclusionThreshold(new BigDecimal(300));
        test.setPensionThreshold(new BigDecimal(400));
    }

    public void testBeneficiaryTravelTest() throws Exception {
//        Person p = buildSimplePerson();
//        Integer year = new Integer(1977);
//        IncomeTest test = createIncomeTest(IncomeTestType.CODE_MEANS_TEST, MeansTestStatus.MT_STATUS_EXEMPT, year);
//        setBeneficiaryTravel(test, getVaFacility(VAFacility.CODE_ALBUQUERQUE));
//        setBeneficiaryTravel(test, getVaFacility(VAFacility.CODE_CONNECTICUT_HCS));
//        setBeneficiaryTravel(test, getVaFacility(VAFacility.CODE_HEC));
//        setBeneficiaryTravel(test, getVaFacility(VAFacility.CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER));
//        p.setIncomeTest(year, test);
//        
//        p = (Person)saveAndLoadInTransaction(p);
//        
//        Person p1 = (Person)p.clone();
//        IncomeTest cloneTest = p.getIncomeTest(year);
//        cloneTest.setBeneficiaryTravels(test.getBeneficiaryTravels());
//        saveAndLoadInTransaction(p1);
    }
    
    public void testGetExpireMeansTest() throws Exception {
    	List list = getDAO().find("meansTestQuery_getExpiredMeansTests");
    	for (int i = 0; i < list.size(); i++) {
			BigDecimal personId = (BigDecimal)list.get(i);
			try {
				getPersonService().getPerson(new PersonIdEntityKeyImpl(personId));
			} catch (Exception ex) {
				//Either log the error or add to exception data that will be printed by the framework
				logger.error("Error while executing Expire MeansTest batch process for person "+personId+" Reason: "+ ex);
			}
		}
    }
}
