/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.financials.InProcessFinancialInfo;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.SerializationUtils;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/**
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class InProcessFinancialsTest
    extends AbstractKeyedEntityDAOTestCase {

    Integer incomeYear = new Integer(2003);
    protected boolean shouldCommitCreate() {
        return true;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        
        //just use any object for testing purpose.
        SiteYear sy = new SiteYear();
        sy.setFacility(getRandomVAFacility());
        sy.setYear(incomeYear);
        byte[] data = SerializationUtils.serialize(sy);
        
        InProcessFinancialInfo inProcessFinancial = new InProcessFinancialInfo();
        inProcessFinancial.setIncomeYear(incomeYear);
        inProcessFinancial.setInProcessData(new BASE64Encoder().encode(data));
        person.setInProcessFinancial(incomeYear, inProcessFinancial);
        return person;
     }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person) obj;
        InProcessFinancialInfo inProcessFinancial = person.getInProcessFinancial(incomeYear);
        System.out.println(inProcessFinancial.getInProcessData().getClass().getName());

        byte[] decodedData = new BASE64Decoder().decodeBuffer(inProcessFinancial.getInProcessData());
        Object decodedObj  = SerializationUtils.deserialize(decodedData);
        System.out.println(decodedObj.getClass().getName());       
        System.out.println((SiteYear)decodedObj);
    }
}