/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 17, 2006
 *
 */
package gov.va.med.esr.common.persistent.hibernate;



// Java classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.ivmdm.IVMDMExtractBatch;
import gov.va.med.esr.common.model.ivmdm.IVMDMExtractRecord;
import gov.va.med.esr.common.model.ivmdm.IVMMigration;
import gov.va.med.esr.common.model.lookup.IVMDMType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.esr.service.IVMDMService;
import gov.va.med.esr.service.PersonService;

import java.util.Date;
/**
 * @author Yi He
 * @version 1.0
 */
public class IVMDMPersistenceTest extends AbstractCommonTestCase {
    private IVMDMService ivmDMService;
   
    public void setIVMDMService(IVMDMService s) {
    	this.ivmDMService = s;
    }
	public IVMDMPersistenceTest() {
		super();				
        super.setDefaultRollback(false);
	}

	public void testGetIVMMigrationByPersonAndIncomeYear() throws Exception {
		PersonEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey("68");
	    IVMMigration ivmMigration = ivmDMService.findIVMMigration(key,new Integer(2005));
	    assertNotNull(ivmMigration);
	}
	
	public void testSaveIVMMigration() throws Exception {
		PersonEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey("68");
		IVMMigration vimMigration = new IVMMigration();
		vimMigration.setPersonEntityKey(key);
		vimMigration.setIcn("12345");
		vimMigration.setLoadFailureReason(null);
		vimMigration.setIncomeYear(new Integer(2002));
		vimMigration.setMigrationDate(new Date());
		vimMigration.setRemigrate(false);
		ivmDMService.saveIVMMigration(vimMigration);
	}
	public void testIVMDMType() throws Exception {
		IVMDMType ivmType = (IVMDMType) getLookupService().getByCode(IVMDMType.class, "1"); 
		assertNotNull(ivmType);
	}
	
	public void testSaveExtractBatch() throws Exception {
		IVMDMExtractBatch batch = new IVMDMExtractBatch();
		IVMDMType type = (IVMDMType) getLookupService().getByCode(IVMDMType.class, "1"); 
		batch.setMigrationType(type);
		batch.setExtractStartDate(new Date());
		batch.setExtractEndDate(new Date());
		
		IVMDMExtractRecord record = new IVMDMExtractRecord();
		record.setExtractBatch(batch);
		record.setIcn("12345");
		record.setIncomeYear(new Integer(2005));		
		batch.addExtractRecord(record);
		
		ivmDMService.saveIVMDMExtractBatch(batch);
	}
	
//	public void testGetLastExtractDate() throws Exception {
//		Date d = ivmDMService.getLastExtractDate();
//		this.assertNotNull(d);		
//		System.out.println("last extract date = " + d);
//	}
//	
//	public void testGetPersonChangeLogSinceLastExtract() throws Exception {
//		List l = ivmDMService.getPersonChangeLogsSinceLastExtract();
//		this.assertNotNull(l);
//		this.assertTrue(!l.isEmpty());
//	}
		
//	public void testGetLatestMigratedYear() throws Exception {
//		PersonEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey("68");
//		Integer y = ivmDMService.getLatestMigratedYear(key);
//		System.out.println("last migrated year" +  y);
//	}
	public void testPersonSubmittedAdvice() throws Exception {
		PersonService ps = (PersonService) this.applicationContext.getBean("personService");
		Person p = ps.getPerson(CommonEntityKeyFactory.createPersonIdEntityKey("68"));
		IncomeTest it = (IncomeTest)p.getIncomeTest(new Integer(2004));
		it.setAdjudicationDate(new Date());
		this.getDAO().evict(p);
		FinancialsService fs = (FinancialsService)this.applicationContext.getBean("financialsService");
		fs.updateFinancialAssessment(new Integer(2004),p);
	}
}

