/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EGTSiteStatistic;
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase.DAOTestMode;
import gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase.QueryInfo;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Date;

/**
 * JUnit test for EGT Setting
 * 
 * @author DNS   MANSOG
 * @date Aug 6, 2005 9:09:33 PM
 * @version 1.0
 */
public class HealthCareProviderTest extends AbstractKeyedEntityDAOTestCase {
    
	protected DAOTestMode[] setUpTests() {
		return new DAOTestMode[] { /*TEST_CREATE, */TEST_RETRIEVE, TEST_QUERY };
	}

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        
    	HealthCareProvider provider = createHealthCareProvider();   	
    	return provider;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        assertNotNull("Null object for modification. ", obj);
      
        HealthCareProvider provider = (HealthCareProvider)obj;
        provider.setDegree("Dr.");
        provider.setPractitionerId("532723");
    }
    
 	protected QueryInfo[] getNamedQueries() {

 		String[] paramNames = new String[] { "PractitionerId" };
		Object[] params = new String[] { "532723" };
		QueryInfo query1 = new QueryInfo("providerQuery_GetByPractitionerId", paramNames, params);

		
		return new QueryInfo[] {query1};
	}	    
    
}