/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.math.BigDecimal;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.demographic.hibernate.AddressDAOImpl;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;


/**
 * @author Yi He
 * @author DNS   MANSOG
 * @version 1.0
 */
public class HealthBenefitPlanTest
    extends AbstractKeyedEntityDAOTestCase {

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		Person p = buildSimplePerson();
		p.getHealthBenefitProfile().addHealthBenefitPlan(createHealthBenefitPlan());
		return p;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		Person p = (Person) obj;
	
		Set plans = p.getHealthBenefitProfile().getHealthBenefitPlans();
		for (Iterator iter = plans.iterator(); iter.hasNext();) {
        HealthBenefitPlan plan = (HealthBenefitPlan)iter.next();
      	plan.setPlanType(getLookupService().getHealthBenefitPlanTypeByCode("126"));
        plan.setChangeSource(getLookupService().getDataChangeSourceByCode("E"));
        plan.setChangeSite(getLookupService().getVaFacilityByCode("442"));
    }
	}

}