package gov.va.med.esr.common.persistent.hibernate;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.comms.Document;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.comms.FileInfo;
import gov.va.med.esr.common.model.lookup.DocumentType;
import gov.va.med.esr.common.persistent.comms.FileInfoDAO;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;
import gov.va.med.esr.common.util.AbstractCommonTestCase;

public class HandbookTest extends AbstractCommonTestCase {
	
	/*
	 * This test class is for all Handbook related tests
	 */
	public void testFileInfoDAO()
	{
		
		String id = "12";

        try
        {
            FileInfoDAO dao =
            	((FileInfoDAO)applicationContext.getBean("fileInfoDAO"));
            
            FileInfo fi = dao.getFileInfoById(new BigDecimal(id));
    		String fileLoc = null;
    		String fileName = fi.getName();
    		String mtPt = fi.getDirectory().getMountPoint().getName();
    		String dirName = fi.getDirectory().getName();
    		String fullPath = mtPt + dirName + fileName;
            
            assertEquals("0000001003222003V811379000000_BENEFITS_PROFILE_V1.PDF", fileName);
            assertEquals("/u02/esr/4.0.0/batchProcess", mtPt);
            assertEquals("/Handbook/2011/07/27-0/", dirName);
            assertEquals("/u02/esr/4.0.0/batchProcess/Handbook/2011/07/27-0/0000001003222003V811379000000_BENEFITS_PROFILE_V1.PDF", fullPath);
            
            id = "54321";
            fi = dao.getFileInfoById(new BigDecimal(id));
            assertEquals(null, fi);
		}
		catch( Exception e ) {
			fail( "Failed to find the FileInfo with id= " + id + ". Exception:" + e );
	    }
	}
	
	public void testDocTypeHandbookOrBenefitsProfie()
	{
		String vpid = "0000001008590828V365457000000";
		try
		{
			DocumentReceipt dr = this.getHandBookService().getDocumentReceiptDao().findDocumentReceiptById(new BigDecimal("1"));
			Set docSet = dr.getDocuments();
			DocumentType dt = null;
			for (Iterator it =docSet.iterator(); it.hasNext(); )
			{
				dt = ((Document)it.next()).getDocumentType();
				if (DocumentType.isHandBook(dt))
					assertEquals(true, dt.getName().contains("Handbook"));
				else if (DocumentType.isBenefitsProfile(dt))
					assertEquals(true, dt.getName().contains("Benefits Profile"));						
			}
			
		}catch( Exception e ) {
			fail( "Failed to getLatestHandbookInformation() with vpid= " + vpid + ". Exception:" + e );
		}
	}

}
