/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 10, 2005
 */

package gov.va.med.esr.common.persistent.hibernate;

import java.math.BigDecimal;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 */
public class FinancialDetailTest extends DataSetupTestCase {

    public FinancialDetailTest(String name) {
        super(name);
    }

    /**
     * insert/select/delete from DB Object deleted from person because of
     * one-to-many relationship to person
     */
    public void testSelectInsertDelete() {
        try {
            person = getPerson();
            FinancialStatement financialStatement = new FinancialStatement();
            financialStatement.setIsPost2005Format(Boolean.FALSE);
            person.setFinancialStatement(new Integer(2005), financialStatement);

            Asset asset = new Asset();
            asset.setAmount(new BigDecimal(8000));
             AssetType assetType = getLookupService().getAssetTypeByCode("S");

            Expense expense = new Expense();
            expense.setAmount(new BigDecimal(500));
            ExpenseType expenseType = getLookupService().getExpenseTypeByCode("03");

            Income income = new Income();
            income.setAmount(new BigDecimal(5000));
            IncomeType incomeType = getLookupService().getIncomeTypeByCode("3");
            
            Debt debt = new Debt();
            debt.setAmount(new BigDecimal(800));
            
            financialStatement.setAsset(assetType, asset);
            financialStatement.setExpense(expenseType, expense);
            financialStatement.setIncome(incomeType, income);
            financialStatement.setDebt(debt);
            
            // insert new object
            person.setFinancialStatement(financialStatement.getIncomeYear(),financialStatement);
            personDao.saveObject(person);

            // make changes to children to test out deletion of previous children
            debt = new Debt();
            debt.setAmount(new BigDecimal(900));
            financialStatement.setDebt(debt);
                     
            asset = new Asset();
            asset.setAmount(new BigDecimal(9000));
            financialStatement.setAsset(assetType, asset);          
            
            personDao.saveObject(person);

            FinancialStatement f = person.getFinancialStatement(financialStatement.getIncomeYear());
            if(financialStatement.equals(f) && f.getAssets() != null && f.getExpenses() != null && f.getDebt() != null)
                logger.info("FinancialDetails test successful");
            else
                fail("Failed FinancialDetails test");

        } catch (Exception ex) {
            if (logger.isDebugEnabled())
                logger.trace("Failed to FinancialStatement", ex);
            fail("Failed FinancialDetails test");
        }
    }
    private Person person = null;
}