/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Aug 23, 2005
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Calendar;
import java.util.Set;

// Java classes

// Library classes

// Framework classes

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */

public class FeeBasisTest extends AbstractKeyedEntityDAOTestCase {

    private VAFacility facility;

    protected void customSetUp() throws Exception {
        facility = getLookupService().getVaFacilityByCode(VAFacility.CODE_CONNECTICUT_HCS.getName());
        super.customSetUp();
    }

	/**
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        FeeBasis feeBasis = createFeeBasis();
        feeBasis.setReportSite(facility);
        person.addFeeBasis(feeBasis);
        return person;
    }

	/**
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person)obj;
        assertNotNull("Set of FeeBasis should never be null.", person.getFeeBasis());
        assertNotNull("Retrieved FeeBasis Object is null.", person.getFeeBasis(facility));
        Set feeBasisSet = person.getFeeBasis(facility);
        if (feeBasisSet.size() > 0){
            FeeBasis feeBasis = (FeeBasis) feeBasisSet.iterator().next();
            Calendar date = Calendar.getInstance();
            date.add(Calendar.DATE, 10);
            feeBasis.setAuthorizationFromDate(date.getTime());
        }
    }
}
