/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Aug 16, 2005
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.util.DataSetupTestCase;

// Java classes

// Library classes

// Framework classes

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class EnrollmentOverrideTest extends DataSetupTestCase {
    public EnrollmentOverrideTest(String name) {
        super(name);
        super.setDefaultRollback(false);        
    }

    /**
     * Insert a new persist object
     * 
     * @see junit.framework.TestCase#setUp()
     * @throws Exception
     */
    public void setUpData() throws Exception {
        Person person = getPerson();
        EnrollmentOverrideReason reason = getLookupService().getEnrollmentOverrideReasonByCode("1"); 
        	
        this.enrollmentOverride = new EnrollmentOverride();
        enrollmentOverride.setOverride(Boolean.TRUE);
        enrollmentOverride.setOverrideBy("HEC user");
        enrollmentOverride.setOverrideComment("Some comment");
        enrollmentOverride.setOverrideReason(reason);
        enrollmentOverride.setOverrideDate(new Date());
    }    

    public void testUpdateEnrollmentOverride() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

    	    EnrollmentOverride override = (EnrollmentOverride) p.getEnrollmentOverride();
    	    if(override == null) {
        		p.setEnrollmentOverride(this.enrollmentOverride);
           		personDao.saveObject(p);
     	    }

    	    EnrollmentOverride overrideRetrieved = (EnrollmentOverride)((Person) personDao.getByKey(p.getEntityKey())).getEnrollmentOverride();
    	    overrideRetrieved.setOverrideDate(new Date());
            personDao.saveObject(p);
            
            EnrollmentOverride overrideFinal = (EnrollmentOverride)((Person) personDao.getByKey(p.getEntityKey())).getEnrollmentOverride();
            if(overrideFinal.equals(overrideRetrieved))
     		    return;                          
  	        fail("Did not update override");
     	}
     	catch(Exception ex) {
     		fail("Failed to get override", ex);
     	}
     }
    
    public void testAddGetEnrollmentOverride() throws Exception {
       
    	try {
    	    
	        Person p = getPerson();
	        p.setEnrollmentOverride(enrollmentOverride);
	   	
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    EnrollmentOverride retrievedOverride = (EnrollmentOverride) retrievedPerson.getEnrollmentOverride();
    		if(enrollmentOverride.getOverrideReason().equals(retrievedOverride.getOverrideReason())) {
    		    System.out.println("Got override  = " + enrollmentOverride);
    		    return;    		
            }
            fail("Could not find override ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get override", ex);
    	}
    }

    private EnrollmentOverride enrollmentOverride;

}

