/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;
import java.util.List;

import gov.va.med.esr.service.EGTService;


import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.person.Person;

/**
 * JUnit test for Enrollment Determination persistence.
 * 
 * @author DNS   MANSOG
 * @date Aug 6, 2005 9:51 PM
 * @version 1.0
 */
public class EnrollmentDeterminationTest extends AbstractKeyedEntityDAOTestCase {
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        EGTService egtService = (EGTService) this.applicationContext.getBean( "egtService");
        EnrollmentDetermination edt = createEnrollmentDetermination();
        edt.setPrimaryEligiblity(createEligibility());
        edt.addSecondaryEligibility(createEligibility());
        edt.addSecondaryEligibility(createEligibility());
        edt.addOtherEligibility(createEligibility());
        edt.setEgtSetting(egtService.getCurrentEGTSetting());
        person.setEnrollmentDetermination(edt);
        return person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        assertNotNull("Null object for modification. ", obj);
        Person person = (Person)obj;
        EnrollmentDetermination edt = person.getEnrollmentDetermination();
        edt.setEgtSetting(createEGTSetting());
        edt.setOverridden(Boolean.TRUE);
        edt.setPrimaryEligiblity(createEligibility());
        edt.removeSecondaryEligibility((Eligibility) edt.getSecondaryEligibilities().iterator().next());
    }
    
    protected Eligibility createEligibility() throws Exception {
        Eligibility elig = new Eligibility();
        elig.setType(getRandomEligibilityType());
        return elig;
    }
    
	protected EligibilityType getRandomEligibilityType() throws Exception {
		List types = getLookupService().getAllEligibilityTypes();
		return (EligibilityType) selectRandomly(types);
	}
}
