/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;


// ESR classes
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author Yi He
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EmailTest extends DataSetupTestCase {
    private Email email = null;
    
    public EmailTest(String name) {
        super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {
	    email = new Email();
        email.setAddress("edbtest@gmail.com");
        EmailType type = getLookupService().getEmailTypeByCode("1");
   	    email.setType(type);
    }
    
    public void tearDownData() throws Exception {        
    	email = null;
    }
    
    public void testAddEmailAddress() throws Exception {
        try {
        	
        	// link address to person
        	Person p = getPerson();
        	p.addEmail(email);
        	
	   	
        	// save address with person
        	personDao.saveObject(p);
	   	   	
        }
       	catch(Exception ex) {
       		ex.printStackTrace();
        	fail("Failed to add email address", ex);
        }        
    }
    
    public void testUpdateEmailAddress() throws Exception {
        
    	try {     	    
     	   	// insert an email
 	        Person p = getPerson();

     	    Set emails = p.getEmails();
     	    
     	   if(emails.isEmpty()) {
    		p.addEmail(email);
       		personDao.saveObject(p);
       		emails = ((Person) personDao.getByKey(p.getEntityKey())).getEmails();
 	    }
     	   
     	    Iterator iter = emails.iterator();
     	   if (iter.hasNext()) {
            Email em = (Email) iter.next();
            em.setAddress("blahblah@test.com");
 		    personDao.saveObject(p);     		    
 		    return;                
        }
  	        fail("Did not update email");
     	}
     	catch(Exception ex) {
     		fail("Failed to get email", ex);
     	}
     }

    public void testGetEmailAddress() throws Exception {
    	try {
    	    
    	   	// insert an email
	        Person p = getPerson();
	        p.removeAllEmails();
	        p.addEmail(email);
	       
    	   	// save email with person
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database
	     	Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
	     	Set emails = retrievedPerson.getEmails();
    	    Iterator iter = emails.iterator();
    	    System.out.println("got email from retrieved");
    	    while (iter.hasNext()) {
    	        Email em = (Email)iter.next();
    	        if (email.getAddress().toString() == em.getAddress().toString())
    		    //if(email.equals(em))
    		    { 
    		        //logger.info("Got email = " + em);
    		    	System.out.println("Got email right = " + em);
    		    	return;  
    		    }
    		    
            }
            fail("Could not find email ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get email", ex);
    	}
    }

    public void testSameTypeEmails() throws Exception {
        Person p = buildSimplePerson();
        int currentEmailCount = p.getEmails().size();
        Email email1 = createEmail(EmailType.CODE_PRIVATE);
        Email email2 = createEmail(EmailType.CODE_PRIVATE);
        Email email3 = createEmail(EmailType.CODE_PRIVATE);
        
        p.addEmail(email1);
        p.addEmail(email2);
        p.addEmail(email3);
        assertEquals("3 emails not added as expected. ", p.getEmails().size(), currentEmailCount+3);
    }
}
