/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author DNS   MANSOG
 * @version 1.0
 */
public class EligibilityVerificationTest extends AbstractKeyedEntityDAOTestCase {
    
    private EligibilityVerification ev;
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        ev = createEligibilityVerification();
        person.setEligibilityVerification(ev);
        return person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person)obj;
    	EligibilityVerification verification = person.getEligibilityVerification();
    	assertNotNull("EligibilityVerification not saved correctly, its null.", verification);
    	assertTrue("VerificationMethod not same as expected.", ev.getVerificationMethod().equals(verification.getVerificationMethod()));
    	assertTrue("VerificationSource not same as expected.", ev.getVerificationSource().equals(verification.getVerificationSource()));
        person.setEligibilityVerification(createEligibilityVerification());
    }
}

