/*
 * Created on Nov 29, 2005
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.util.DataSetupTestCase;

import java.util.Iterator;
/**
 * @author Yi He
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EligibilityTest extends DataSetupTestCase {
     
    public EligibilityTest(String name) {
        super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {
    }
         
    public void tearDownData() throws Exception {
    }    
    
 
    public void testRemoveEligibility() throws Exception {
        ReceivedEligibility re = this.createReceivedEligibility(EligibilityType.MEXICAN_BORDER_WAR);
        Person p = (Person) getPerson();
        p.removeAllReceivedSecondaryEligibilities();
        p.addReceivedSecondaryEligibility(re);
        ReceivedEligibility r = null;
        Iterator iter = p.getReceivedSecondaryEligibilities().iterator();
        if(iter.hasNext())
        	r = (ReceivedEligibility)iter.next();
        p.removeReceivedSecondaryEligibility(r);
        personDao.saveObject(p);
        
	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
        
        assertEquals(retrievedPerson.getReceivedSecondaryEligibilities().size(),0);
    } 
}
