/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EGTSiteStatistic;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Date;

/**
 * JUnit test for EGT Setting
 * 
 * @author DNS   MANSOG
 * @date Aug 6, 2005 9:09:33 PM
 * @version 1.0
 */
public class EGTSettingTest extends AbstractKeyedEntityDAOTestCase {
    
 	protected DAOTestMode[] setUpTests() {
		return new DAOTestMode[] { /*TEST_CREATE, */TEST_RETRIEVE, TEST_QUERY };
	}

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        EGTSetting egt = createEGTSetting();
        EGTProcessStatistic egtStat = createEGTProcessStatistic();
        EGTSiteStatistic siteStat1 = createEGTSiteStatistic();
		egtStat.setEGTSiteStatistic(siteStat1.getFacility(), siteStat1);
        EGTSiteStatistic siteStat2 = createEGTSiteStatistic();
		egtStat.setEGTSiteStatistic(siteStat2.getFacility(), siteStat2);
        egt.setProcessStatistic(egtStat);
        
        return egt;
    }

    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        assertNotNull("Null object for modification. ", obj);
        EGTSetting egt = (EGTSetting)obj;
        egt.setDisable(Boolean.TRUE);
        egt.setComments("update comments");
        egt.setEffectiveDate(getDate(2009, 9, 25));
        egt.setFederalRegisterDate(getDate(2009, 9, 25));
        egt.setPriorityGroup(getRandomEnrollmentPriorityGroup());
        egt.setPrioritySubGroup(getRandomEnrollmentPrioritySubGroup());
        
        // process statistics
        EGTProcessStatistic processStat = egt.getProcessStatistic();
        assertNotNull("Must have original processStat.", processStat);
        
        processStat.setBeneficiaryProcessedCount(new Integer(50));
        processStat.setBeneficiaryNotEnrolledCount(new Integer(100));
        processStat.setProcessStartDate(new Date());
        processStat.setProcessEndDate(new Date());
        processStat.setEgtProcessStatus(getRandomEGTStatus());

        
        int statCount = processStat.getSiteStatistics().size();
		assertTrue("Must have 2 site statistics that saved earlier.", statCount==2);
//		for (Iterator iter = processStat.getSiteStatistics().iterator(); iter.hasNext();) {
//            EGTSiteStatistic siteStatistic = (EGTSiteStatistic) iter.next();
//            siteStatistic.setBeneficiaryNotEnrolledCount(new Integer(statCount+75));
//        }
//        processStat.addSiteStatistic(createEGTSiteStatistic());
        
    }
    
 	protected QueryInfo[] getNamedQueries() {
		
		QueryInfo query1 = new QueryInfo("egtSettingQuery_FindActive");	
		QueryInfo query2 = new QueryInfo("egtSettingQuery_FindFuture");
		
		return new QueryInfo[] {query1, query2 };
	}	    
    
}