/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.comms.Document;
import gov.va.med.esr.common.model.comms.DocumentAccessLog;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.comms.FileInfo;
import gov.va.med.esr.common.model.lookup.DocumentType;
import gov.va.med.esr.common.persistent.comms.DocumentReceiptDAO;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Date;
import java.util.List;
import java.util.Set;


public class DocumentReceiptTest extends AbstractKeyedEntityDAOTestCase {
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
      DocumentReceipt documentReceipt = new DocumentReceipt();
      documentReceipt.setVPIDValue("0000001008590775V635010000000");
      
      Document document = new Document();
      document.setDocumentType((DocumentType) getLookupService().getByCode(DocumentType.class,
  				DocumentType.CODE_HANDBOOK_BY_CMS.getCode()));
      
      FileInfo fileInfo = new FileInfo();
      fileInfo.setName("0000001008590775V635010000000_HANDBOOK_V1.PDF");
     
      DocumentAccessLog log = new DocumentAccessLog();
      
      log.setAccessDate(new Date());

     // fileInfo.addDocumentAccessLog(log);
    	document.setFileInfo(fileInfo);
    	documentReceipt.addDocument(document);
      
    	return documentReceipt;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        assertNotNull("Null object for modification. ", obj);
        
        DocumentReceipt documentReceipt = (DocumentReceipt) obj;
        
       
        Set documents = documentReceipt.getDocuments();
        Document document = documents==null? ((Document) documents.iterator().next()) : null;
        
        if (document!=null) {
        	document.setDocumentType((DocumentType) getLookupService().getByCode(DocumentType.class,
    				DocumentType.CODE_HANDBOOK_BY_VCG.getCode()));
        	
        	FileInfo fileInfo = document.getFileInfo();
        	
        }
    }
  
    public void testDelete() throws Exception {
    	DocumentReceiptDAO dao =
      	((DocumentReceiptDAO)applicationContext.getBean("documentReceiptDAO"));
    		
    	List receipts = dao.findDocumentReceipts("0000001008590728V283240000000");
    	if (receipts != null && receipts.size() > 0) {
    		DocumentReceipt receipt = (DocumentReceipt) receipts.iterator().next();
    		dao.deleteDocumentReceipt(receipt);
    		this.getSessionFactory().getCurrentSession().flush();
    		// commit only if we really want the data removed from the database
    		// super.setComplete();
    	}
    }
}
