package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * 
 * @author Rajiv Patnaik Created on Nov 4, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class CountyTest extends AbstractKeyedEntityDAOTestCase
{
    private static final String VALID_COUNTY_NAME = "Montgomery";

    private static final String VALID_STATE_CODE = "OH";

    private static final String INVALID_COUNTY_NAME = "Montgomery1234";

    /*
     * protected DAOTestMode[] setUpTests() { return new
     * DAOTestMode[]{TEST_QUERY}; }
     */
    public void testNamedQueries()
    {
        try
        {
            LookupService lookupService = getLookupService();

            // Single "full" zip code lookup
            County county = lookupService.getCountyByCountyNameAndStateCode(
                    VALID_COUNTY_NAME, VALID_STATE_CODE);
            assertNotNull("County is null", county);
            assertEquals("County Name does not match", VALID_COUNTY_NAME, county.getName());
            assertEquals("State Postal name does not match", VALID_STATE_CODE, county.getState().getPostalName());
            
            county = lookupService.getCountyByCountyNameAndStateCode(
                    INVALID_COUNTY_NAME, VALID_STATE_CODE);
            assertNull("County is not null", county);

        } catch (Exception e)
        {
            fail("Did not pass testNamedQueries ", e);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception
    {
        // TODO Auto-generated method stub
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception
    {
        // TODO Auto-generated method stub

    }

}