/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 10, 2005
 */

package gov.va.med.esr.common.persistent.hibernate;

import java.util.List;

import gov.va.med.esr.common.model.financials.ConsentAuthorization;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 */
public class ConsentAuthorizationTest extends DataSetupTestCase {

    public ConsentAuthorizationTest(String name) {
        super(name);
    }

    /**
     * retrive the same row from DB
     */
    public void test() {
        try {
            Person person = getPerson();
            ConsentAuthorization newOne = new ConsentAuthorization(person);

            // insert
            getDAO().saveObject(newOne);

            // select
            ConsentAuthorization retrivedOne = (ConsentAuthorization) getDAO()
                    .getByKey(newOne.getEntityKey());
            assertNotNull(retrivedOne);
            
            getDAO().removeObject(newOne.getEntityKey());
            
            List list = getDAO().find( "from ConsentAuthorization c where c.identifier = ? ", new Object[]{ newOne.getEntityKey() } );
            assertTrue(list == null || list.size() == 0);

        } catch (Exception ex) {
            ex.printStackTrace();
            if (logger.isDebugEnabled())
                logger.trace("Failed to consentAuthorization", ex);
        }
    }

}