/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on May 23, 2006
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.util.DataSetupTestCase;

// Java classes

// Library classes

// Framework classes

// EDB Classes
import gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Yi He
 * @version 1.0
 */
public class ConfidentialAddressCategoryTest extends DataSetupTestCase {

	private ConfidentialAddressCategoryType cat = null;
	
	public ConfidentialAddressCategoryTest() {
		super();
        super.setDefaultRollback(false);
	}

    public void setUpData() throws Exception {
    	cat = (ConfidentialAddressCategoryType)this.getLookupService().getByCode(ConfidentialAddressCategoryType.class,ConfidentialAddressCategoryType.CODE_ELIGIBILITY_ENROLLMENT);
    }
    
    public void testAddGetConfidentialAddressCategory() throws Exception {
       try {
        	
        	// link address to person
        	Person p = getPerson();
        	p.addConfidentialAddressCategory(cat);
        	
	   	
        	// save address with person
        	personDao.saveObject(p);	   	   	
        	
            Person retrieved = (Person) personDao.getByKey(p.getEntityKey());
            this.assertTrue(retrieved.getConfidentialAddressCategories().size()>0);
        }
       	catch(Exception ex) {
       		ex.printStackTrace();
        	fail("Failed to add email address", ex);
        }        
    }
    
    public void testRemoveConfidentialAddressCategory() throws Exception {
        try {
         	
         	// link address to person
         	Person p = getPerson();
         	p.removeConfidentialAddressCategory(cat);
         	
 	   	
         	// save address with person
         	personDao.saveObject(p);	   	   	
         }
        	catch(Exception ex) {
        		ex.printStackTrace();
         	fail("Failed to add email address", ex);
         }        
     }    
}

