/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;
import java.util.List;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.comms.CommsTransByFormNumber;
import gov.va.med.esr.common.model.comms.CommsTransLog;
import gov.va.med.esr.common.model.lookup.MessageType;


/**
 * JUnit test for CommsTransLog persistence.
 * 
 * @author DNS   MANSOG
 * @date Aug 6, 2005 9:51 PM
 * @version 1.0
 */
public class CommsTransLogTest extends AbstractKeyedEntityDAOTestCase {
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        
    	
    	CommsTransLog transLog = new CommsTransLog();
    	transLog.setFileName("W0533201.ltr");
    	transLog.setFileProcessStartDate(new Date());
    	transLog.setFileProcessEndDate(new Date());
    	transLog.setFileReceivedDate(new Date());
    	transLog.setFileRecordCount(new Integer(20));
    	
		MessageType type = getLookupService().getMessageTypeByCode("ORUZ07-E");
		transLog.setTransmissionType(type);
	   		    	
    	transLog.addTransByFormNumber(createCommsTransByFormNumber());
    	
        return transLog;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        assertNotNull("Null object for modification. ", obj);
        CommsTransLog transLog = (CommsTransLog)obj;
        transLog.setFileProcessEndDate(new Date());
        transLog.setFileName("W0533202.ltr");
        transLog.setFileRecordCount(new Integer(21));
        List formCountList = transLog.getCommsTransByFormNumberList();
        if (formCountList != null && !formCountList.isEmpty()) {
        	CommsTransByFormNumber formsCount = (CommsTransByFormNumber) formCountList.get(0);
        	updateCommsTransByFormNumber(formsCount);
        }
    }
    
    protected CommsTransByFormNumber createCommsTransByFormNumber() throws Exception {
       	CommsTransByFormNumber formsCount = new CommsTransByFormNumber();
    	formsCount.setFormNumber("742-600B");
    	formsCount.setFormNumberErrorReasons("test error reason");
       	formsCount.setFormNumberRejectReasons("test error reject reason");
        formsCount.setFormNumberRecordCount(new Integer(35));
        return formsCount;
    }
    
    protected void updateCommsTransByFormNumber(CommsTransByFormNumber formsCount) throws Exception {
       	formsCount.setFormNumber("742-623B");
       	formsCount.setFormNumberErrorReasons("update error reason");
        formsCount.setFormNumberRejectReasons("update error reject reason");                   	
        formsCount.setFormNumberRecordCount(new Integer(5));
    }
}
