/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 10, 2005
 */

package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.Procedure;
import gov.va.med.esr.common.model.lookup.DescriptorType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 */
public class CatastrophicDisabilityTest extends DataSetupTestCase {

    
	private LookupsDAO procedureDAO;	
	private LookupsDAO conditionDAO;
	private LookupsDAO diagnosisDAO;

    public CatastrophicDisabilityTest(String name) {
        super(name);
        super.setDefaultRollback(false);        
    }	

    /**
     * Insert a new persist object
     * 
     * @see junit.framework.TestCase#setUp()
     * @throws Exception
     */
    public void setUpData() throws Exception {
//        conditionDAO = (LookupsDAO)applicationContext.getBean("conditionDAO");
//        procedureDAO = (LookupsDAO)applicationContext.getBean("procedureDAO");
//        diagnosisDAO = (LookupsDAO)applicationContext.getBean("diagnosisDAO");
//        this.catastrophicDisability = new CatastrophicDisability();
//        this.catastrophicDisability.setDeterminedBy("testuser");       
//        this.catastrophicDisability.setDecisionDate(new Date());
    }    
    
    public void testDescriptors() throws Exception {
    	
    	CatastrophicDisability cd  = new CatastrophicDisability();
    	CDDescriptor cdd = new CDDescriptor();
    	cd.addCDDescriptor(cdd);
    	assertNotNull(cd.getCDDescriptors());
    	assertTrue(cd.getCDDescriptors().size() > 0);
    }

    public void testCDLookups() throws Exception {
    	DescriptorType dt = this.getLookupService().getDescriptorTypeByCode(DescriptorType.CODE_PARAPLEGIA.getCode());
    }
    public void testUpdateCatastrophicDisability() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

    	    ClinicalDetermination cd = (ClinicalDetermination) p.getClinicalDeterminationByType(CatastrophicDisability.class);
    	    if(cd == null) {
        		p.addClinicalDetermination(this.catastrophicDisability);
           		personDao.saveObject(p);
     	    }

    	    CatastrophicDisability cdRetrieved = (CatastrophicDisability)((Person) personDao.getByKey(p.getEntityKey())).getClinicalDeterminationByType(CatastrophicDisability.class);
    	    cdRetrieved.setReviewDate(new Date());
            personDao.saveObject(p);
            
            CatastrophicDisability cdFinal = (CatastrophicDisability)((Person) personDao.getByKey(p.getEntityKey())).getClinicalDeterminationByType(CatastrophicDisability.class);
            if(cdFinal.equals(cdRetrieved))
     		    return;                          
  	        fail("Did not update cd");
     	}
     	catch(Exception ex) {
     		fail("Failed to get cd", ex);
     	}
     }
    
    public void testGetAddCatastrophicDisability() throws Exception {
       
    	try {
    	    
	        Person p = getPerson();
	        p.removeAllClinicalDeterminations();
	        p.addClinicalDetermination(this.catastrophicDisability);
	        CDCondition condition = new CDCondition();
	        condition.setCondition(getLookupService().getConditionByCode("3"));
	        CDProcedure procedure = new CDProcedure();
	        procedure.setProcedure(getLookupService().getProcedureByCode("84.08"));
	        CDDiagnosis diagnosis = new CDDiagnosis();
	        diagnosis.setDiagnosis(getLookupService().getDiagnosisByCode("1539"));
	        this.catastrophicDisability.addCondition(condition);
	        this.catastrophicDisability.addDiagnosis(diagnosis);
	        this.catastrophicDisability.addProcedure(procedure);
	        
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    ClinicalDetermination retrievedCD = (ClinicalDetermination) retrievedPerson.getClinicalDeterminationByType(CatastrophicDisability.class);
    		if(catastrophicDisability.equals(retrievedCD)) {
    		    logger.info("Got cd  = " + catastrophicDisability);
    		    return;    		
            }
            fail("Could not find cd ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get cd", ex);
    	}
    }


    private CatastrophicDisability catastrophicDisability;

}