/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 28, 2004
 */

package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */	
public class CancelDeclineTest extends DataSetupTestCase {

	private CancelDecline cd = null;
    
    public CancelDeclineTest(String name) {
    	super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {
        cd  = new CancelDecline();
 
        LookupsDAO typeLookup = (LookupsDAO) this.applicationContext.getBean( "cancelDeclineReasonDAO" );
        CancelDeclineReason reason = getLookupService().getCancelDeclineReasonByCode("1");
        cd.setReason(reason);

        CancelDeclineNotProcessedReason notProcessedReason = getLookupService().getCancelDeclineNotProcessedReasonByCode("1");
        cd.setReasonNotProcessed(notProcessedReason);
        cd.setRemarks("blah blah");
    }

    public void tearDownData() throws Exception {
    	cd = null;
    }
    
    public void testAddCancelDecline() throws Exception {
    	try {
    		// link CancelDecline to person
    		Person p = getPerson();
    		p.setCancelDecline(cd);
	   	
    		// save CancelDecline with person
    		personDao.saveObject(p);    	   
    	}
    	catch (Exception ex) {
    	    ex.printStackTrace();
    		fail("Failed to add CancelDecline", ex);
    	} 
    }
	 
	 public void testUpdateCancelDecline() throws Exception {
        
     	try {     	    
     	   	// insert a CancelDecline
 	        Person p = getPerson();
 	       CancelDecline dec = p.getCancelDecline();
     	    
     	   if(dec.equals(null)) {
    		p.setCancelDecline(cd);
       		personDao.saveObject(p);
       		dec = ((Person) personDao.getByKey(p.getEntityKey())).getCancelDecline();
 	    }
 	    
     	   		dec.setReason(getLookupService().getCancelDeclineReasonByCode("2"));
     	   		personDao.saveObject(p);     		    
     	   		return;                
     	}
     	catch(Exception ex) {
     		fail("Failed to get CancelDecline", ex);
     	}
     }
	 
	 public void testGetCancelDecline() throws Exception {
	       
	    	try {
	    	    
	    	   	// insert a pow
		        Person p = getPerson();
		        p.setCancelDecline(null);
		        p.setCancelDecline(cd);
		   	
	    	   	// save pow with person
		     	personDao.saveObject(p);
		   	   	
	    	    // refresh data from database 
	    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
	    	    CancelDecline dc= retrievedPerson.getCancelDecline();
	    	     
	    	    System.out.println("got CancelDecline from retrieved");
	    		    if(dc.equals(dc)) {
	    		       // logger.info("Got POW = " + pw);
	    		        System.out.println("Got CancelDecline = " + dc);
	    		        return;
	    		    }
	    	}
	    	catch(Exception ex) {
	    		fail("Failed to get CancelDecline", ex);
	    	}
	    }
}