/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Oct 21, 2005
 *
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

import java.util.Date;
import java.util.Set;

/**
 * @author Yi He
 * @version 1.0
 */
public class BeneficiaryTravelTest extends DataSetupTestCase {
    private BeneficiaryTravel beneTravel = null;
    private Integer year = null;
    private VAFacility vaFacility = null;
    
    public BeneficiaryTravelTest(String name) {
        super(name);
        super.setDefaultRollback(false);
    }
    
    public void setUpData() throws Exception {        
        this.vaFacility = this.getLookupService().getVaFacilityByCode("552");
        this.year = new Integer(2005);
        this.beneTravel = createBeneficiaryTravel(year,vaFacility);
    }
    
    public void tearDownData() throws Exception {
    	beneTravel = null;
    }    
    
    public void testGetByYear() throws Exception {
        Person p = getPerson();	        
		p.setBeneficiaryTravel(this.year,this.vaFacility,this.beneTravel);        		
   		personDao.saveObject(p);
   		Set s = ((Person) personDao.getByKey(p.getEntityKey())).getBeneficiaryTravels(this.year);
   		assertEquals(1,s.size());
    }

    public void testUpdateBeneficiaryTravel() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

 	        BeneficiaryTravel t = p.getBeneficiaryTravel(this.year, this.vaFacility);
     	    if(t==null) {
        		p.setBeneficiaryTravel(this.year,this.vaFacility,this.beneTravel);        		
           		personDao.saveObject(p);
           		t = ((Person) personDao.getByKey(p.getEntityKey())).getBeneficiaryTravel(this.year, this.vaFacility);
     	    }
     	    
     	    if (t!=null) {
     	        t.setClaimDate(new Date());
    		    personDao.saveObject(p);     		    
     		    return;                
            }
  	        fail("Did not update bene travel");
     	}
     	catch(Exception ex) {
     		fail("Failed to update bene travel", ex);
     	}
     }
    
    public void testAddGetBeneTravel() throws Exception {
       
    	try {
    	    
    	   	// insert a phone
	        Person p = getPerson();	        
    		p.setBeneficiaryTravel(this.year,this.vaFacility,this.beneTravel);        		
       		personDao.saveObject(p);
       		BeneficiaryTravel t = ((Person) personDao.getByKey(p.getEntityKey())).getBeneficiaryTravel(this.year, this.vaFacility);
       		assertNotNull(t);
 	    }
    	catch(Exception ex) {
    		fail("Failed to get phone", ex);
    	}
    }
   
}

