/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import java.util.Iterator;
import java.util.Set;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Yi He
 * @author DNS   MANSOG
 */
public class AssociationTest
    extends AbstractKeyedEntityDAOTestCase {

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
     */
    protected AbstractKeyedEntity setUpTestObject() throws Exception {
        Person person = buildSimplePerson();
        person.addAssociation(createAssociation("TempCompany1", "Spouse"));
        person.addAssociation(createAssociation("TempCompany2", "Son"));
        return person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
     */
    protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
        Person person = (Person) obj;
        person.setClaimFolderNumber("claim786");
        Set associations = person.getAssociations();
        assertNotNull("Association can not be null here.", associations);
        assertTrue("Must have 2 associations as added before. ",
                associations.size() == 2);
        for (Iterator iter = associations.iterator(); iter.hasNext();) {
            Association association = (Association) iter.next();
            association.setOrganizationName("EDS");
            association.setRelationship("Daughter");
            association.setAddress(null);
        }
        person.removeAssociation((Association) associations.iterator().next());
        person.addAssociation(createAssociation("TempCompany3", "Sister"));
    }

    public void testAddMsgAssociation() throws Exception {
        Person person = (Person)saveAndLoadInTransaction(buildSimplePerson());
        person.addAssociation(createAssociation("Org2","Son"));
        
        saveAndLoadInTransaction(person);
    }
    public void testAssociationBackRef() throws Exception {
        Person person1 = (Person)saveAndLoadInTransaction(buildSimplePerson());
        person1.addAssociation(createAssociation("Org1","Son"));
        assertNotNull(person1.getAssociations());
        assertTrue(person1.getAssociations().size() == 1);

        Person person2 = (Person)saveAndLoadInTransaction(buildSimplePerson());
        person2.addAssociation(createAssociation("Org2","Son"));
        assertNotNull(person2.getAssociations());
        assertTrue(person2.getAssociations().size() == 1);

        Person newPerson= buildSimplePerson();
        newPerson.addAssociation(createAssociation("Org1","Son"));

        Association assocation1 = (Association) person1.getAssociations().iterator().next();
        Association assocation2 = (Association) person2.getAssociations().iterator().next();
        Association newAssocation = (Association) newPerson.getAssociations().iterator().next();
        
        setPreOwnedAssociation(person1, assocation2);
        setPreOwnedAssociation(person2, assocation1);
        setPreOwnedAssociation(buildSimplePerson(), assocation1);
        setPreOwnedAssociation(buildSimplePerson(), assocation2);
        setPreOwnedAssociation(person1, newAssocation);
        setPreOwnedAssociation(newPerson, assocation2);
    }

    private void setPreOwnedAssociation(Person person, Association assocation1) {
        try {
            //try to add to another person. Should throw exception
            person.addAssociation(assocation1);
            fail("Should had thrown IllegalArgumentException as association is already owned by another Person.");
        } catch (IllegalArgumentException ex) {
            //as expected
        }
    }
    
    public void testChangeAssociationCollection() throws Exception {
        Person p = buildSimplePerson();
        p.addAssociation(createAssociation("Org1", "Spouse"));
        p.addAssociation(createAssociation("Org2", "Daughter"));
        p = (Person)saveAndLoadInTransaction(p);
        
       // Person p2 = (Person)p.clone();
      //  p2.addAssociation(createAssociation("Org3", "Son"));
      
        p.removeAllAssociations();
     //   p.addAllAssociations(p2.getAssociations());
        
        saveAndLoadInTransaction(p);
    }
}