/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 10, 2005
 */

package gov.va.med.esr.common.persistent.hibernate;

import java.util.Date;

import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.DataSetupTestCase;

/**
 * @author DNS   SUNS
 * @author Yi He
 */
public class ApplicationTest extends DataSetupTestCase {
    public ApplicationTest(String name) {
        super(name);
        super.setDefaultRollback(false);        
    }

    /**
     * Insert a new persist object
     * 
     * @see junit.framework.TestCase#setUp()
     * @throws Exception
     */
    public void setUpData() throws Exception {
        this.application = new Application();
        application.setApplicationDate(new Date());
    }    

    public void testUpdateApplication() throws Exception {
        
     	try {     	    
 	        Person p = getPerson();

    	    Application application = (Application) p.getApplication();
    	    if(application == null) {
        		p.setApplication(this.application);
           		personDao.saveObject(p);
     	    }

    	    Application applicationRetrieved = (Application)((Person) personDao.getByKey(p.getEntityKey())).getApplication();
    	    applicationRetrieved.setApplicationDate(new Date());
            personDao.saveObject(p);
            
            Application applicationFinal = (Application)((Person) personDao.getByKey(p.getEntityKey())).getApplication();
            if(applicationFinal.equals(applicationRetrieved))
     		    return;                          
  	        fail("Did not update application");
     	}
     	catch(Exception ex) {
     		fail("Failed to get application", ex);
     	}
     }
    
    public void testAddGetApplication() throws Exception {
       
    	try {
    	    
	        Person p = getPerson();
	        p.setApplication(application);
	   	
	     	personDao.saveObject(p);
	   	   	
    	    // refresh data from database 
    	    Person retrievedPerson = (Person) personDao.getByKey(p.getEntityKey());
    	    Application retrievedApplication = (Application) retrievedPerson.getApplication();
    		if(application.equals(retrievedApplication)) {
    		    System.out.println("Got application  = " + application);
    		    return;    		
            }
            fail("Could not find application ");
    	}
    	catch(Exception ex) {
    		fail("Failed to get application", ex);
    	}
    }

    private Application application;
}