/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

import java.util.Iterator;
import java.util.Set;
import java.math.BigDecimal;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.demographic.hibernate.AddressDAOImpl;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;


/**
 * @author Yi He
 * @author DNS   MANSOG
 * @version 1.0
 */
public class AddressTest
    extends AbstractKeyedEntityDAOTestCase {
    
	protected DAOTestMode[] setUpTests() {
		return new DAOTestMode[] { TEST_UPDATE_COMMIT};
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#setUpTestObject()
	 */
	protected AbstractKeyedEntity setUpTestObject() throws Exception {
		Person p = buildSimplePerson();
		p.addAddress(createAddress());
		return p;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.persistent.hibernate.AbstractKeyedEntityDAOTestCase#modifyTestObject(gov.va.med.fw.model.AbstractKeyedEntity)
	 */
	protected void modifyTestObject(AbstractKeyedEntity obj) throws Exception {
		Person p = (Person) obj;
		p.setSensitiveRecord(Boolean.TRUE);
		p.setVeteran(Boolean.TRUE);
		Set addresses = p.getAddresses();
		for (Iterator iter = addresses.iterator(); iter.hasNext();) {
            Address address = (Address) iter.next();
            BadAddressReason badAddrReason = getLookupService().getBadAddressReasonByCode(BadAddressReason.CODE_HOMELESS.getName());
            address.setBadAddressReason(badAddrReason);
            address.setCity("Reston");
        }
	}
	public void testgetPersonAddresses()
    {

        try
        {
            AddressDAO dao =
            	((AddressDAO)applicationContext.getBean("addressDAO"));
		dao.getPersonAddresses(new BigDecimal("84379"));
		
		}
		catch( Exception e ) {
			fail( "Failed to find the log entry. Exception:" + e );
	    }
	}
}