package gov.va.med.esr.common.model.financials;

import java.math.BigDecimal;
import java.util.Calendar;

import junit.framework.Assert;
import junit.framework.TestCase;

public class RelaxationPercentageTest extends TestCase {

    public void testReferenceDates() throws Exception {
        int incomeYear = 2005;
        RelaxationPercentage rp = new RelaxationPercentage(new BigDecimal(
                "11.25"), incomeYear);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(rp.getReferenceStartDate());

        Calendar endCal = Calendar.getInstance();
        endCal.setTime(rp.getReferenceEndDate());
        Calendar[] cals = new Calendar[] { startCal, endCal };

        Assert.assertEquals(startCal.get(Calendar.MONTH), 0);
        Assert.assertEquals(startCal.get(Calendar.DAY_OF_MONTH), 1);
        Assert.assertEquals(endCal.get(Calendar.MONTH), 11);
        Assert.assertEquals(endCal.get(Calendar.DAY_OF_YEAR), 365);
        
        for (int i = 0; i < cals.length; i++) {
            Assert.assertEquals(cals[i].get(Calendar.YEAR), 2005);
            Assert.assertEquals(cals[i].get(Calendar.HOUR), 0);
            Assert.assertEquals(cals[i].get(Calendar.MINUTE), 0);
            Assert.assertEquals(cals[i].get(Calendar.SECOND), 0);
            Assert.assertEquals(cals[i].get(Calendar.MILLISECOND), 0);
        }
    }
}
