/********************************************************************
 * Copyright  2008 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import java.io.*;

import org.apache.commons.lang.StringUtils;


/**
 * Verifier for expires means test data.
 * 
 * 
 * Created Jun 5, 2008 9:52:50 PM
 * 
 * @author DNS   GALLAS
 */

public class VerifyNotSubjectToMeansTest {
    
    static String FILE_NAME = "D:\\Development\\ESR\\SQL\\ExpireMeansTest\\verifyNotSubject2.DAT";
    static String OUT_FILE_NAME = "D:\\Development\\ESR\\SQL\\ExpireMeansTest\\otherRecords.DAT";
    static private int nbrNotSubjectMilDisabTrue = 0;
    static private int nbrNotSubjectDischargeTrue = 0;
    static private int nbrNotSubjectMedicaidTrue = 0;
    static private int nbrNotSubjectRule4 = 0;
    static private int nbrNotSubjectRule5 = 0;
    static private int nbrNotSubjectRule6 = 0;
    static private int nbrNotSubjectRule7To22 = 0;
    static private int nbrOtherRecords = 0;
    static private int totalRecords = 0;
    
    public static final String[]    mtNotRequiredPrimaryEligibilityCodes   = {
        "2", // AID_AND_ATTENDANCE
        "15", // HOUSEBOUND
        "4", // NSC_VA_PENSION
        "18", // PRISONER_OF_WAR
        "22", // PURPLE_HEART_RECIPIENT 
        "17", // WORLD_WAR_I
        "16", // MEXICAN_BORDER_WAR 
        "8", // HUMANTARIAN_EMERGENCY
        "19", // TRICARE_CHAMPUS 
        "9", // SHARING_AGREEMENT
        "7", // ALLIED_VETERAN 
        "12", // CHAMPVA
        "14", // EMPLOYEE 
        "13", // COLLATERAL_OF_VETERAN
        "6", // OTHER_FEDERAL_AGENCY 
        "10" // REIMBURSABLE_INSURANCE 
    };
    
    
    public static void main(String args[]) throws Exception {
        File datFile = new File(FILE_NAME);
        File outFile = new File(OUT_FILE_NAME);
        verify(datFile, outFile);
    }
    
    private static boolean contains(String[] strings, String string)
    {
        if (strings == null) return false;
        for (int i = 0; i < strings.length; i++)
        {
            if (StringUtils.equals(strings[i], string))
                return true;
        }
        return false;
    }

    static private void verify(File aFile, File outFile) {
        String lastPersonId = "";
        
        try {
          BufferedReader input =  new BufferedReader(new FileReader(aFile));
          BufferedWriter output =  new BufferedWriter(new FileWriter(outFile));
          try {
            String line = null; //not declared within while loop
        
            while (( line = input.readLine()) != null){
                String[] tokens = StringUtils.split(line, ' ');
                
                /*for (int i=0; i<tokens.length; i++) {
                System.out.println("Token " + i + ": " + tokens[i]);
                }*/
                
                
                //Rule 1
                if (tokens[1].equals("1")) {
                    nbrNotSubjectMilDisabTrue++; 
                }
                // Rule 2
                else if (tokens[2].equals("1")) {
                    nbrNotSubjectDischargeTrue++;
                }
                // Rule 3
                else if (tokens[3].equals("1")) {
                    nbrNotSubjectMedicaidTrue++;
                }
                // Rule 4 and Rule 6
                else if (tokens[4].equals("P") && tokens[5].equals("3")) {
                    int scPercent = Integer.parseInt(tokens[6]);
                    int monetaryBenefit = Integer.parseInt(tokens[7]);
                    
                    if (scPercent > 0) {
                        nbrNotSubjectRule6++; 
                    }
                    else if (scPercent == 0 && monetaryBenefit > 0) {
                        nbrNotSubjectRule4++; 
                    }
                    else {
                        if (!tokens[0].equals(lastPersonId)) {
                            output.write(line);
                            output.newLine();
                        }
                        nbrOtherRecords++; 
                    }
                }
                // Rule 5
                else if (tokens[4].equals("P") && tokens[5].equals("1")) {
                    nbrNotSubjectRule5++; 
                }
                //  Rules 7-22
                else if (tokens[4].equals("P") && contains(mtNotRequiredPrimaryEligibilityCodes, tokens[5])) {
                    nbrNotSubjectRule7To22++;
                }
                // Problem
                else {
                    if (!tokens[0].equals(lastPersonId)) {
                        output.write(line);
                        output.newLine();
                    }
                    nbrOtherRecords++;
                }

                lastPersonId = tokens[0];
                totalRecords++;
            }
          }
          finally {
            input.close();
            output.close();
          }
        }
        catch (IOException ex){
          ex.printStackTrace();
        }
        
        System.out.println("Military Disability Count: " + nbrNotSubjectMilDisabTrue);
        System.out.println("Discharge Count: " +  nbrNotSubjectDischargeTrue);
        System.out.println("Medicaid Count: " + nbrNotSubjectMedicaidTrue);
        System.out.println("Rule 4 Count: " + nbrNotSubjectRule4);
        System.out.println("Rule 5 Count: " + nbrNotSubjectRule5);
        System.out.println("Rule 6 Count: " + nbrNotSubjectRule6);
        System.out.println("Rules 7-22 Count: " + nbrNotSubjectRule7To22);
        System.out.println("Other Count: " + nbrOtherRecords);
        
        System.out.println("Total Records: " + totalRecords);
        
        int calculatedTotal = nbrNotSubjectMilDisabTrue + nbrNotSubjectDischargeTrue + nbrNotSubjectMedicaidTrue +
        nbrNotSubjectRule4 + nbrNotSubjectRule5 + nbrNotSubjectRule6 + nbrNotSubjectRule7To22 +
        nbrOtherRecords;
        
        System.out.println("Calculated Total Records: " + calculatedTotal);
        
        if ( calculatedTotal == totalRecords) {
            System.out.println("Numbers add up.");
            if (nbrOtherRecords != 0) {
                System.out.println("Why are there other records?");
            }
        }
        else {
            System.out.println("Numbers DO NOT add up."); 
        }
      }

}
