package gov.va.med.esr.common.batchprocess;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.fw.scheduling.ScheduledProcess;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Mar 10, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class TestRequestSSNVerificationProcess extends
        AbstractScheduledProcessTest
{

	private String getVetRecordsSQL = "SELECT * FROM ssn_verification_detail d WHERE d.SSN_VERIFICATION_ID IS NULL AND d.VERIFICATION_REQUEST_NUMBER IS NULL and d.ssn_id is null and d.ssn is null ORDER BY  d.SSN_VERIFICATION_detail_ID DESC";
    private String getSDRecordsSQL = "SELECT * FROM SSN s  WHERE s.SSN_VRFN_STATUS_TYPE_ID = 1507631 AND s.STD_SSNTYPE_ID = 1506641";
    private String produce7SDRecordsSQL = "UPDATE SSN s SET s.SSN_VRFN_STATUS_TYPE_ID = 1507631 WHERE s.SSN_ID > 375312550 AND s.STD_SSNTYPE_ID = 1506641";
	private RequestSSNVerificationProcess batchProcess;
	/**
	 * @return Returns the batchProcess.
	 */
	public RequestSSNVerificationProcess getBatchProcess() {
		return batchProcess;
	}

	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(RequestSSNVerificationProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}    

	private void checkRecordBeforeStart() throws Exception
	{
		List lst = getDAO().executeSQLQuery(this.getVetRecordsSQL);
		if (lst != null && lst.size() > 0)
			throw new Exception ("Veteran Record not empty");
		
		lst = getDAO().executeSQLQuery(this.getSDRecordsSQL);
		if (lst != null && lst.size() > 0)
			throw new Exception ("Spouse/Dependant Record not empty");
		
	}
	public void testFourVetRecordsOnly() throws Exception
	{
		checkRecordBeforeStart();
		produceFourVetRecords();
		
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) applicationContext.getBean("common.batchprocess.requestSSNVerification");
		process.invoke(null);
	}
	
	private void produceFourVetRecords() throws Exception
	{
		PersonIdEntityKeyImpl personKeys[] = {new PersonIdEntityKeyImpl(new BigDecimal("373960472")), 
				new PersonIdEntityKeyImpl(new BigDecimal("373960539")), 
				new PersonIdEntityKeyImpl(new BigDecimal("373960559")),
				new PersonIdEntityKeyImpl(new BigDecimal("373960659")) };
		
		//insert 4 new vet records
		Person person = null;
		person = this.getPersonService().getPerson(personKeys[0]);
		this.getPersonHelperService().addToSSNVerificationQueue(person);
		
		person = this.getPersonService().getPerson(personKeys[1]);
		this.getPersonHelperService().addToSSNVerificationQueue(person);
		
		person = this.getPersonService().getPerson(personKeys[2]);
		this.getPersonHelperService().addToSSNVerificationQueue(person);

		person = this.getPersonService().getPerson(personKeys[3]);
		this.getPersonHelperService().addToSSNVerificationQueue(person);
	}
	
	private void produceSevenSDRecords() throws Exception
	{
		getDAO().executeSQLQuery(this.produce7SDRecordsSQL);
	}
	
	public void testFourVetSevenSDRecords() throws Exception
	{
//		checkRecordBeforeStart();
		
		//insert 4 new vet records
		produceFourVetRecords();
		
		//insert 7 new SD records
//		produceSevenSDRecords();
		
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) applicationContext.getBean("common.batchprocess.requestSSNVerification");
		process.invoke(null);
	}
	
	public void testFourVetSevenSDRecordsMax3() throws Exception
	{
		checkRecordBeforeStart();
		
		//insert 4 new vet records
		produceFourVetRecords();
		
		//insert 7 new SD records
		produceSevenSDRecords();
		
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) applicationContext.getBean("common.batchprocess.requestSSNVerification");
		((RequestSSNVerificationProcess)process).setMasRecordPerFile(3);
		
		process.invoke(null);
	}
	
	public void testFourVetSevenSDRecordsMax4() throws Exception
	{
		checkRecordBeforeStart();
		
		//insert 4 new vet records
		produceFourVetRecords();
		
		//insert 7 new SD records
		produceSevenSDRecords();
		
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) applicationContext.getBean("common.batchprocess.requestSSNVerification");
		((RequestSSNVerificationProcess)process).setMasRecordPerFile(4);
		
		process.invoke(null);
	}
	
	public void testFourVetSevenSDRecordsMax7() throws Exception
	{
//		checkRecordBeforeStart();
		
		//insert 4 new vet records
//		produceFourVetRecords();
		
		//insert 7 new SD records
//		produceSevenSDRecords();
		
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) applicationContext.getBean("common.batchprocess.requestSSNVerification");
		((RequestSSNVerificationProcess)process).setMasRecordPerFile(7);
		
		process.invoke(null);
	}
	
	public void testFourVetSevenSDRecordsMax11() throws Exception
	{
//		checkRecordBeforeStart();
		
		//insert 4 new vet records
//		produceFourVetRecords();
		
		//insert 7 new SD records
//		produceSevenSDRecords();
		
		//run the batch job
		ScheduledProcess process = (ScheduledProcess) applicationContext.getBean("common.batchprocess.requestSSNVerification");
		((RequestSSNVerificationProcess)process).setMasRecordPerFile(11);
		
		process.invoke(null);
	}
}
