/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.scheduling.ScheduledProcess;

import gov.va.med.esr.common.model.person.Person;

import gov.va.med.ps.model.PersonVPID;



/**
 * Initial javadoc for class TestReceiveSignatureInformationFile.
 * TODO - Add content here
 * 
 * Created Feb 2, 2006 5:57:15 PM
 * @author DNS   BOHMEG
 */
public class TestReceiveSignatureInformationFile extends AbstractScheduledProcessTest {
	private ReceiveSignatureInformationFileProcess batchProcess;

	/**
	 * @return Returns the batchProcess.
	 */
	public ReceiveSignatureInformationFileProcess getBatchProcess() {
		return batchProcess;
	}

	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(ReceiveSignatureInformationFileProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}
	
	/**
	 * This will create the right type of Person who can be hardcoded to use with Signature Data
	 * such that Z messages will get created
	 * 
	 * @throws Exception
	 */
	public void testCreatePersonWithPrimaryIncomeTest() throws Exception {
		Person person = buildSeededPerson(PersonVPID.HARDCODED_PSIM_VPID_VALUE5);
		attachPrimaryMeansTest(person);
		person = getPersonService().save(person);
		assertNotNull(person.getEntityKey());
		logPersonKeys("Created", person); 
	}	
}
