package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.ScrollableCallback;
import gov.va.med.fw.scheduling.ScheduledProcess;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Apr 28, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class TestOPPExtractProcess extends AbstractCommonTestCase
	implements ScrollableCallback 
{
    private static final String		EXIST_IN_RANGE_QUERY	= "personQuery_RecordsExistInRange";

    public  void testCDConditionExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractCDConditionProcess");
    }

    public  void testCDDiagnosisExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractCDDiagnosisProcess");
    }

    public  void testCDProcedureExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractCDProcedureProcess");
    }

    public  void testEligibilityExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractEligibilityProcess");
    }

    public  void testPeriodOfServiceExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractPeriodOfServiceProcess");
    }

    public  void testRatedDisabilitiesExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractRatedDisabilitiesProcess");
    }

    public  void testCombatEpisodesExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractCombatEpisodesProcess");
    }
    
    public  void testMainFileExtract() throws Exception
    {
        invokeProcess("common.batchprocess.OPPExtractMainFileProcess");
    }    
    
    private void invokeProcess(String processName) throws Exception
    {
        ScheduledProcess process = (ScheduledProcess)applicationContext.getBean(processName);
        process.invoke();       
    }
    
    public void testOppExtractQueryOnly() throws Exception
    {
    	BigDecimal batchIncrementSize = new BigDecimal(1000000);
    	String queryName = "OPPExtract.mainFile.query";
       	
     	QueryInfo qi = new QueryInfo(queryName);
    	qi.setFetchSize(500);
		qi.setParamNames(new String[] {"startId", "endId"});

    	BigDecimal maxPersonId = new BigDecimal(370425108);
    	BigDecimal startId = new BigDecimal(15000000);
    	BigDecimal endId = null;
    	
    	Date startTime = new Date(System.currentTimeMillis());
    	
    	logger.info("start time = " + startTime);
    	DataProcessExecutionContext context = null;
  		context = createDataProcessExecutionContext();
  	
    	while (startId.compareTo(maxPersonId) <= 0) {
   		
       		endId = startId.add(batchIncrementSize);
        		
       		if (recordsFoundInRange(startId, endId)) {

       			qi.setParamValues(new Object[] {startId, endId});
    	
       			logger.info("startId = " + startId.intValue() + ". "); //"OPPExtractMainFileQuery returned " + results.size() + " records.");
       		
       			getDAO().scroll(this, qi, (OPPExtractExecutionContext)context); 
      	   		
       			startId = endId;
       		}
    	}
    	Date finishedTime = new Date(System.currentTimeMillis());
    	logger.info("finish time = " + finishedTime + ".  elapsed time = " + (finishedTime.getTime()- startTime.getTime()));
    }
    
    private boolean recordsFoundInRange(BigDecimal startId, BigDecimal endId) throws DAOException
    {
     	List results = getDAO().findByNamedQueryAndNamedParam(EXIST_IN_RANGE_QUERY, new String[] {"min", "max"}, new Object[] {startId, endId});
     	if (results != null && !results.isEmpty())
     		return true;
     	else
     		return false; 
    }

	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.ScrollableCallback#handleScrolledData(java.util.List)
	 */
	public void handleScrolledData(QueryIncrementTracker tracker) {
		logger.info("In handleScrolledData.  Data Size = " + tracker.getIncrementalData().size());
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.ScrollableCallback#continueScrolling()
	 */
	public boolean continueScrolling(QueryIncrementTracker tracker) {
		return true;
	}

    private DataProcessExecutionContext createDataProcessExecutionContext()
    {
        OPPExtractExecutionContext context = new OPPExtractExecutionContext();
		context.setProcessStatistics(createProcessStatistics());
		return context;
    }    
    
    private ProcessStatistics createProcessStatistics()
    {
        return new OPPExtractProcessStatistics();
    }

}


