/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 30, 2006
 *
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.datasync.IVMDataSynchronizationProducerProcess;
import gov.va.med.fw.scheduling.ScheduledProcess;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

/**
 * TestIVMDataSynchronizationProducerProcess
 * Created Apr 14, 2006 2:46:19 PM
 * @author DNS   MANSOG
 *
 */
public class TestIVMDataSynchronizationProducerProcess extends
		AbstractScheduledProcessTest {
    private IVMDataSynchronizationProducerProcess batchProcess;

    public TestIVMDataSynchronizationProducerProcess() {
		super();
	}

    /**
	 * @return Returns the batchProcess.
	 */
	public IVMDataSynchronizationProducerProcess getBatchProcess() {
		return batchProcess;
	}

	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(IVMDataSynchronizationProducerProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	/**
     *  (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}    
    
    public void testProcess() throws Exception {
        super.testProcess();
    }

    public void testSelectionCriteria() throws Exception {
        String queryName = "ivmDMQuery_checkSelectionCriteria";
        String[] paramNames = {"personId", "incomeYear"};
        Object[] paramValues = {new BigDecimal(68), new Integer(2004)};
        List list = getDAO().findByNamedQueryAndNamedParam(queryName, paramNames, paramValues);
        System.out.println(list.get(0));
    }
    
    public void testLastExtractDate() throws Exception {
        String queryName = "ivmDMQuery_GetLastIVMExtractDate";
        List list = getDAO().find(queryName);
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            Object[] elements = (Object[]) iter.next();
            System.out.println(elements[0]+"  "+elements[1]);
        }        
    }
}