/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;

import gov.va.med.esr.common.batchprocess.datasync.HECLegacyCommunicationsFileData;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDataSynchronizationProducerProcess;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.esr.service.CommsLogService;

/**
 * Initial javadoc for class TestHECLegacyDataSynchronizationProducerProcess.
 * TODO - Add content here
 * 
 * Created Apr 7, 2006 3:27:20 PM
 * @author DNS   BOHMEG
 */
public class TestHECLegacyDataSynchronizationProducerProcess extends
		AbstractScheduledProcessTest {
	private HECLegacyDataSynchronizationProducerProcess batchProcess;
	private CommsLogService commsLogService = null;
	/* (non-Javadoc)
	 * @see gov.va.med.esr.common.batchprocess.AbstractScheduledProcessTest#getScheduledProcess()
	 */
	protected ScheduledProcess getScheduledProcess() {
		return getBatchProcess();
	}
	
	protected Object getExecutionArguments() {
		return DateUtils.createCalendar(2006, 8, 18).getTime();
	}

	/**
	 * @return Returns the batchProcess.
	 */
	public HECLegacyDataSynchronizationProducerProcess getBatchProcess() {
		return batchProcess;
	}

	/**
	 * @param batchProcess The batchProcess to set.
	 */
	public void setBatchProcess(
			HECLegacyDataSynchronizationProducerProcess batchProcess) {
		this.batchProcess = batchProcess;
	}

	public void testCCR6577()
	{
		//find a person with multiple comms log with empty letter sent date
		String personId = "143379";

		if (commsLogService == null)
		{
			this.commsLogService = (CommsLogService)this.applicationContext.getBean("commsLogService");
		}
		
		List commData = null;
		
		try{
			commData = extractCommunicationsData(personId);
		} catch (Exception e)
		{
			System.out.print(e.toString());
		}
		assertNotNull(commData);
		assertEquals(commData.size(), 3);
	}
	
	// test CCR#6577. Since this method is private in HECLegacyDataSynchronizationProducerProcess,
	// copy it and pass in personId here for a quick test
	private List extractCommunicationsData(String personId) throws ServiceException {
		List data = new ArrayList();
//		List commsLogEntries = commsLogService.findLogEntriesByPersonId(person.getPersonEntityKey().getKeyValueAsString());
		List commsLogEntries = commsLogService.findLogEntriesByPersonId(personId);
		Iterator itr = commsLogEntries != null ? commsLogEntries.iterator() : null;
		CommsLogEntry logEntry = null;
		HECLegacyCommunicationsFileData item = null;
		
		/* since there can be more than one CommsLogEntry of each form type for a Person,
		 * per agreement with HECLegacy and the limitation that they can only have one,
		 * preprocess to find the "latest" (using the mailing status modified date)
		 */
		Map uniqueCommsLogEntries = new HashMap();
		CommsLogEntry best = null;
		while (itr != null && itr.hasNext()) {
			logEntry = (CommsLogEntry) itr.next();
			if(logEntry.getFormNumber() == null)
				continue; // can't use one that has no form number
			
			// get the best and compare creation date 
			best = (CommsLogEntry) uniqueCommsLogEntries.get(logEntry.getFormNumber());
			if(best != null) {
				MailingStatusLink bestStatus = best.getLatestMailingStatus();
				Date bestDateForComparison = bestStatus != null ? bestStatus.getModifiedOn() :
					best.getModifiedOn();
				
				MailingStatusLink targetStatus = logEntry.getLatestMailingStatus();
				Date targetDateForComparison = targetStatus != null ? targetStatus.getModifiedOn() :
					logEntry.getModifiedOn();
				
				if(targetDateForComparison.after(bestDateForComparison))
					uniqueCommsLogEntries.put(logEntry.getFormNumber(), logEntry);
			} else {
				uniqueCommsLogEntries.put(logEntry.getFormNumber(), logEntry);
			}			
		}
		
		itr = uniqueCommsLogEntries.values().iterator();
		while (itr != null && itr.hasNext()) {
			logEntry = (CommsLogEntry) itr.next();
			
			item = new HECLegacyCommunicationsFileData();
			// since HECLegacy can only handle one ActionComment, use the latest
			item.setActionMessage(logEntry.getLatestActionComment());
			item.setLetterForm(logEntry.getFormNumber());
			item.setRemail(logEntry.getRemailIndicator());
			item.setFileName(logEntry.getAacExtractNumber());
			MailingStatusLink status = logEntry.getLatestMailingStatus();
			if(status != null)
				item.setStatus(status.getMailingStatus().getCode());
			data.add(item);
		}
		return data;
	}


}
